/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Assertion;
import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class RuleAssertionMessage
implements Rule {
    private final TestCase method;

    RuleAssertionMessage(TestCase test) {
        this.method = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        Collection<Assertion> assertions = this.method.assertions();
        ArrayList<EmptyAssertions> res = new ArrayList<EmptyAssertions>(0);
        if (assertions.isEmpty()) {
            res.add(new EmptyAssertions(this.method));
        }
        assertions.stream().filter(assertion -> !assertion.explanation().isPresent()).map(assertion -> new EmptyAssertionMessage(this.method, (Assertion)assertion)).forEach(res::add);
        return Collections.unmodifiableCollection(res);
    }

    private static final class EmptyAssertionMessage
    implements Complaint {
        private final TestCase method;
        private final Assertion assertion;

        EmptyAssertionMessage(TestCase test, Assertion check) {
            this.method = test;
            this.assertion = check;
        }

        @Override
        public String message() {
            return new ComplaintLinked(String.format("Method '%s' has assertion without message: '%s'", this.method.name(), this.assertion), "Please add the explanation message to make the test more readable", RuleAssertionMessage.class, "empty-assertion-message.md").message();
        }
    }

    private static final class EmptyAssertions
    implements Complaint {
        private final TestCase method;

        EmptyAssertions(TestCase test) {
            this.method = test;
        }

        @Override
        public String message() {
            return new ComplaintLinked(String.format("Method %s doesn't have assertion statements", this.method.name()), "Please add at least one assertion statement to the test method", RuleAssertionMessage.class, "no-assertions.md").message();
        }
    }
}

