/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class RuleCorrectTestName
implements Rule {
    private static final String[] ALLOWED_PREFIXES = new String[]{"IT", "ITCase", "Test", "Tests", "TestCase"};
    private final TestClass test;

    public RuleCorrectTestName(TestClass klass) {
        this.test = klass;
    }

    @Override
    public Collection<Complaint> complaints() {
        String name = this.test.name();
        Set<Complaint> complaints = RuleCorrectTestName.isIncorrectName(name) ? Collections.singleton(new ComplaintLinked(String.format("Test class name should start or end with one of the following prefixes: %s", Arrays.toString(ALLOWED_PREFIXES)), String.format("Please rename the %s test class to start or end with one of the following prefixes: %s", name, Arrays.toString(ALLOWED_PREFIXES)), this.getClass(), "test-class-name.md")) : Collections.emptySet();
        return complaints;
    }

    private static boolean isIncorrectName(String name) {
        String clear = RuleCorrectTestName.withoutExtension(name);
        return Arrays.stream(ALLOWED_PREFIXES).noneMatch(prefix -> clear.startsWith((String)prefix) || clear.endsWith((String)prefix));
    }

    private static String withoutExtension(String with) {
        String result = with.endsWith(".java") ? with.substring(0, with.length() - 5) : (with.endsWith(".class") ? with.substring(0, with.length() - 6) : with);
        return result;
    }
}

