/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.RuleConditional;
import java.util.Collection;

public final class RuleNotCamelCase
implements Rule {
    public static final String NAME = "RuleNotCamelCase";
    private final TestCase test;

    RuleNotCamelCase(TestCase test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new RuleConditional(this::notCamelCase, new ComplaintLinked(new ComplaintWrongTestName(this.test, "test has to be written by using Camel Case").message(), "Please rename the test by using the Camel Case", this.getClass(), "camel-case.md")).complaints();
    }

    private boolean notCamelCase() {
        int stack = 0;
        for (char chr : this.test.name().toCharArray()) {
            if (Character.isUpperCase(chr) && stack == 0) {
                return true;
            }
            if (stack != 0) {
                stack = 0;
            }
            ++stack;
        }
        return false;
    }
}

