/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.RuleConditional;
import java.util.Collection;
import java.util.stream.Stream;

public final class RuleNotContainsTestWord
implements Rule {
    public static final String NAME = "RuleNotContainsTestWord";
    private final TestCase test;

    RuleNotContainsTestWord(TestCase test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new RuleConditional(this::containsTest, new ComplaintLinked(new ComplaintWrongTestName(this.test, "test name doesn't have to contain the word 'test'").message(), "Remove 'test' word from the test name", this.getClass(), "test-word.md")).complaints();
    }

    private boolean containsTest() {
        return Stream.of("test", "TEST", "Test").anyMatch(this.test.name()::contains);
    }
}

