/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.RuleConditional;
import java.util.Collection;

public final class RuleNotSpam
implements Rule {
    private final TestCase test;

    RuleNotSpam(TestCase test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new RuleConditional(() -> !this.notSpam(), new ComplaintLinked(new ComplaintWrongTestName(this.test, "test name doesn't have to contain duplicated symbols").message(), "Remove duplicated symbols from the test name", this.getClass(), "not-spam.md")).complaints();
    }

    private boolean notSpam() {
        int stack = 0;
        char prev = '!';
        for (char chr : this.test.name().toCharArray()) {
            if (chr == prev) {
                ++stack;
            } else {
                stack = 0;
                prev = chr;
            }
            if (stack <= 2) continue;
            return false;
        }
        return true;
    }
}

