/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.RuleConditional;
import java.util.Collection;

public final class RuleNotUsesSpecialCharacters
implements Rule {
    private final TestCase test;

    RuleNotUsesSpecialCharacters(TestCase test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new RuleConditional(this::usesSpecialCharacters, new ComplaintLinked(new ComplaintWrongTestName(this.test, "test name shouldn't contain special characters like '$' or '_'").message(), "Remove all special characters like '$' or '_' from test name", this.getClass(), "not-special-characters.md")).complaints();
    }

    private boolean usesSpecialCharacters() {
        return this.test.name().contains("$") || this.test.name().contains("_");
    }
}

