/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.RuleConditional;
import java.util.Collection;

public final class RulePresentTense
implements Rule {
    private final TestCase test;

    RulePresentTense(TestCase tst) {
        this.test = tst;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new RuleConditional(() -> !this.presentTense(), new ComplaintLinked(new ComplaintWrongTestName(this.test, "the test name has to be written using present tense").message(), "Please, rename the test name using present tense", this.getClass(), "present-tense.md")).complaints();
    }

    private boolean presentTense() {
        char[] chars = this.test.name().toCharArray();
        int prev = 33;
        for (int n : chars) {
            if (Character.isUpperCase((char)n)) {
                return prev == 115;
            }
            prev = n;
        }
        return prev == 115;
    }
}

