/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.TestClass;
import java.util.Collection;
import java.util.Collections;

public final class RuleSuppressed
implements Rule {
    private final Rule delegate;
    private final Collection<String> suppressed;

    public RuleSuppressed(Rule rule, TestClass test) {
        this(rule, test.suppressed());
    }

    RuleSuppressed(Rule rule) {
        this(rule, Collections.singleton(rule.getClass().getSimpleName()));
    }

    RuleSuppressed(Rule rule, TestCase test) {
        this(rule, test.suppressed());
    }

    private RuleSuppressed(Rule rule, Collection<String> hidden) {
        this.delegate = rule;
        this.suppressed = hidden;
    }

    @Override
    public Collection<Complaint> complaints() {
        Collection<Complaint> result = this.isSuppressed() ? Collections.emptyList() : this.delegate.complaints();
        return result;
    }

    private boolean isSuppressed() {
        return this.suppressed.stream().anyMatch(hidden -> hidden.equals(this.delegate.getClass().getSimpleName()));
    }
}

