/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules.ml;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.complaints.ComplaintWrongTestName;
import com.github.lombrozo.testnames.rules.ml.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import opennlp.tools.postag.POSTaggerME;

public final class RulePresentSimpleMl
implements Rule {
    private static final Pattern CAMEL = Pattern.compile("(?=\\p{Lu})");
    private final POSTaggerME model;
    private final TestCase test;

    RulePresentSimpleMl(POSTaggerME tagger, TestCase tst) {
        this.model = tagger;
        this.test = tst;
    }

    @Override
    public Collection<Complaint> complaints() {
        Tag[] parse = Tag.parse(this.model.tag((String[])Stream.concat(Stream.of("It"), Arrays.stream(CAMEL.split(this.test.name()))).map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new)));
        Collection<Complaint> res = parse[1].isVerb() ? Collections.emptyList() : Collections.singleton(new ComplaintWrongTestName(this.test, "Test name should start with a verb"));
        return res;
    }
}

