/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules.ml;

import java.util.Arrays;

public enum Tag {
    CC("CC"),
    CD("CD"),
    DT("DT"),
    EX("EX"),
    FW("FW"),
    IN("IN"),
    JJ("JJ"),
    JJR("JJR"),
    JJS("JJS"),
    LS("LS"),
    MD("MD"),
    NN("NN"),
    NNS("NNS"),
    NNP("NNP"),
    NNPS("NNPS"),
    PDT("PDT"),
    POS("POS"),
    PP("PP"),
    PPZ("PPZ"),
    PRP("PRP"),
    RB("RB"),
    RBR("RBR"),
    RBS("RBS"),
    RP("RP"),
    SENT("SENT"),
    SYM("TO"),
    TO("TO"),
    UH("UH"),
    VB("VB"),
    VBD("VBD"),
    VBG("VBG"),
    VBN("VBN"),
    VBP("VBP"),
    VBZ("VBZ"),
    VH("VH"),
    VHD("VHD"),
    VHG("VHG"),
    VHN("VHN"),
    VHP("VHP"),
    VHZ("VHZ"),
    VV("VV"),
    VVD("VVD"),
    VVG("VVG"),
    VVN("VVN"),
    VVP("VVP"),
    VVZ("VVZ"),
    WWD("WWD"),
    WP("WP"),
    WP_DOLLAR("WP$"),
    WRB("WRB"),
    HASH("#"),
    DOLLAR("$"),
    QM("\""),
    OQM("``"),
    OB("("),
    CB(")"),
    COMMA(","),
    PUNCTUATION(":"),
    UNKNOWN("UNKNOWN");

    private final String tag;

    private Tag(String tag) {
        this.tag = tag;
    }

    boolean isVerb() {
        return Arrays.asList(VB, VBP, VBZ).contains((Object)this);
    }

    static Tag[] parse(String ... tags) {
        return (Tag[])Arrays.stream(tags).map(Tag::parse).toArray(Tag[]::new);
    }

    private static Tag parse(String tag) {
        return Arrays.stream(Tag.values()).filter(t -> t.tag.equals(tag)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return "Tag." + this.name() + "(tag=" + this.tag + ")";
    }
}

