/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import java.nio.file.Path;
import java.nio.file.Paths;

public interface Case {
    public String className();

    public String name();

    public Path path();

    public static final class FakeCase
    implements Case {
        private final String className;
        private final String name;
        private final Path path;

        public FakeCase(String name) {
            this("FakeClass", name, Paths.get(".", new String[0]));
        }

        FakeCase(String className, String name, Path path) {
            this.className = className;
            this.name = name;
            this.path = path;
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Path path() {
            return this.path;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FakeCase)) {
                return false;
            }
            FakeCase other = (FakeCase)o;
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        public String toString() {
            return "Case.FakeCase(className=" + this.getClassName() + ", name=" + this.getName() + ", path=" + this.getPath() + ")";
        }
    }
}

