/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.lombrozo.testnames.Case;
import com.github.lombrozo.testnames.Cases;
import com.github.lombrozo.testnames.javaparser.JavaParserCase;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaTestCode
implements Cases {
    private final Path path;

    public JavaTestCode(Path file) {
        this.path = file;
    }

    @Override
    public Collection<Case> all() {
        try {
            return StaticJavaParser.parse((Path)this.path).getChildNodes().stream().filter(JavaTestCode::isTestClass).flatMap(this::testCases).collect(Collectors.toList());
        }
        catch (ParseProblemException | IOException ex) {
            throw new IllegalStateException(String.format("Failed to parse Java class by path %s", this.path), ex);
        }
    }

    private Stream<JavaParserCase> testCases(Node node) {
        NodeWithMembers clazz = (NodeWithMembers)node;
        return clazz.getMethods().stream().filter(JavaTestCode::isTest).map(method -> new JavaParserCase(clazz.getNameAsString(), method.getNameAsString(), this.path));
    }

    private static boolean isTestClass(Node node) {
        return node instanceof ClassOrInterfaceDeclaration;
    }

    private static boolean isTest(MethodDeclaration method) {
        return !method.isPrivate() && (method.isAnnotationPresent("Test") || method.isAnnotationPresent("ParameterizedTest"));
    }
}

