/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Case;
import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.complaints.WrongTestName;
import com.github.lombrozo.testnames.rules.ConditionalRule;
import java.util.Collection;

public final class NotCamelCase
implements Rule {
    private final Case test;

    NotCamelCase(Case test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new ConditionalRule(this::notCamelCase, new WrongTestName(this.test, "test has to be written by using Camel Case")).complaints();
    }

    private boolean notCamelCase() {
        int stack = 0;
        for (char chr : this.test.name().toCharArray()) {
            if (Character.isUpperCase(chr) && stack == 0) {
                return true;
            }
            if (stack != 0) {
                stack = 0;
            }
            ++stack;
        }
        return false;
    }
}

