/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Case;
import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.complaints.WrongTestName;
import com.github.lombrozo.testnames.rules.ConditionalRule;
import java.util.Collection;
import java.util.stream.Stream;

public final class NotContainsTestWord
implements Rule {
    private final Case test;

    NotContainsTestWord(Case test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new ConditionalRule(this::containsTest, new WrongTestName(this.test, "test name doesn't have to contain the word 'test'")).complaints();
    }

    private boolean containsTest() {
        return Stream.of("test", "TEST", "Test").anyMatch(this.test.name()::contains);
    }
}

