/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Case;
import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.complaints.WrongTestName;
import com.github.lombrozo.testnames.rules.ConditionalRule;
import java.util.Collection;

public final class NotSpam
implements Rule {
    private final Case test;

    NotSpam(Case test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new ConditionalRule(() -> !this.notSpam(), new WrongTestName(this.test, "test name doesn't have to contain duplicated symbols")).complaints();
    }

    private boolean notSpam() {
        int stack = 0;
        char prev = '!';
        for (char chr : this.test.name().toCharArray()) {
            if (chr == prev) {
                ++stack;
            } else {
                stack = 0;
                prev = chr;
            }
            if (stack <= 2) continue;
            return false;
        }
        return true;
    }
}

