/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Case;
import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.complaints.WrongTestName;
import com.github.lombrozo.testnames.rules.ConditionalRule;
import java.util.Collection;

public final class NotUsesSpecialCharacters
implements Rule {
    private final Case test;

    NotUsesSpecialCharacters(Case test) {
        this.test = test;
    }

    @Override
    public Collection<Complaint> complaints() {
        return new ConditionalRule(this::usesSpecialCharacters, new WrongTestName(this.test, "test name shouldn't contain special characters like '$' or '_'")).complaints();
    }

    private boolean usesSpecialCharacters() {
        return this.test.name().contains("$") || this.test.name().contains("_");
    }
}

