/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.xnav;

import com.github.lombrozo.xnav.Empty;
import com.github.lombrozo.xnav.StringNode;
import com.github.lombrozo.xnav.Xml;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DomXml
implements Xml {
    private static final TransformerFactory TFACTORY = TransformerFactory.newInstance();
    private final Node inner;

    DomXml(String xml) {
        this(new StringNode(xml).toNode());
    }

    DomXml(Node node) {
        this.inner = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xml child(String element) {
        Object object = this.sync();
        synchronized (object) {
            NodeList nodes = this.inner.getChildNodes();
            int length = nodes.getLength();
            Xml res = new Empty();
            for (int idx = 0; idx < length; ++idx) {
                Node child = nodes.item(idx);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(element)) continue;
                res = new DomXml(child);
                break;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Xml> attribute(String name) {
        Object object = this.sync();
        synchronized (object) {
            Node item = this.inner.getAttributes().getNamedItem(name);
            Optional<Xml> result = Objects.nonNull(item) ? Optional.of(new DomXml(item)) : Optional.empty();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> text() {
        Object object = this.sync();
        synchronized (object) {
            Optional<String> result = this.inner.getNodeType() == 9 ? Optional.of("") : (this.inner.getNodeType() == 2 ? Optional.of(this.inner.getNodeValue()) : Optional.of(this.inner).map(Node::getTextContent));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<Xml> children() {
        Object object = this.sync();
        synchronized (object) {
            NodeList nodes = this.inner.getChildNodes();
            int length = nodes.getLength();
            return Stream.iterate(0, idx -> idx + 1).limit(length).map(nodes::item).filter(Objects::nonNull).map(DomXml::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String name() {
        Object object = this.sync();
        synchronized (object) {
            return this.inner.getNodeName();
        }
    }

    @Override
    public DomXml copy() {
        return new DomXml(this.inner.cloneNode(true));
    }

    @Override
    public Node node() {
        return this.inner;
    }

    public String toString() {
        Object object = this.sync();
        synchronized (object) {
            try {
                Transformer transformer = TFACTORY.newTransformer();
                transformer.setOutputProperty("version", "1.0");
                transformer.setOutputProperty("encoding", "UTF-8");
                if (!(this.inner instanceof Document)) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                }
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(this.inner), new StreamResult(writer));
                return writer.toString();
            }
            catch (TransformerConfigurationException econf) {
                throw new IllegalStateException(String.format("Failed to configure Transformer for printing XML to a string: %s", this), econf);
            }
            catch (TransformerException exception) {
                throw new IllegalStateException(String.format("Failed to transform XML: %s to a human-readable string", this), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.sync();
        synchronized (object) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj == null || this.getClass() != obj.getClass()) {
                result = false;
            } else {
                DomXml other = (DomXml)obj;
                result = this.inner.isEqualNode(other.inner);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.sync();
        synchronized (object) {
            return Objects.hashCode(this.inner);
        }
    }

    private Object sync() {
        return this.inner;
    }
}

