/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.xnav;

import com.github.lombrozo.xnav.Empty;
import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xml;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

final class Xpath {
    private final Xml root;
    private final String path;

    Xpath(Xml root, String path) {
        this.root = root;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<Xml> nodes() {
        XpathNode xpath = new XPathParser(new XPathLexer(this.path).tokens()).parsePath();
        Object object = this.sync();
        synchronized (object) {
            return xpath.nodes(Stream.of(this.root));
        }
    }

    private Object sync() {
        return this.root;
    }

    private static boolean toBoolean(Object obj) {
        boolean result;
        if (obj instanceof String) {
            result = !((String)obj).isEmpty();
        } else if (obj instanceof Xml) {
            result = !(obj instanceof Empty);
        } else if (obj instanceof Boolean) {
            result = (Boolean)obj;
        } else {
            throw new IllegalStateException(String.format("Cannot convert %s to boolean", obj));
        }
        return result;
    }

    private static String toString(Object obj) {
        String result;
        if (obj instanceof String) {
            result = (String)obj;
        } else if (obj instanceof Xml) {
            result = ((Xml)obj).text().orElse("");
        } else {
            throw new IllegalStateException(String.format("Cannot convert %s to string", obj));
        }
        return result;
    }

    private static enum Type {
        DSLASH("//"),
        SLASH("/"),
        AT("@"),
        LPAREN("\\("),
        RPAREN("\\)"),
        LBRACKET("\\["),
        RBRACKET("\\]"),
        NUMBER("[0-9]+"),
        LT("\\<"),
        GT("\\>"),
        EQUALS("="),
        VALUE("'[^']*'|\"[^\"]*\""),
        AND("and|AND"),
        OR("or|OR"),
        COMMA(","),
        NAME("[a-zA-Z_][a-zA-Z0-9_-]*");

        private final String subpattern;

        private Type(String pattern) {
            this.subpattern = pattern;
        }

        String lexeme() {
            return this.subpattern;
        }

        private static Pattern pattern() {
            return Pattern.compile(Arrays.stream(Type.values()).map(a -> String.format("(?<%s>%s)", a.name(), a.lexeme())).collect(Collectors.joining("|")));
        }
    }

    private static final class Token {
        private final Type type;
        private final String text;
        private final int position;

        private Token(Type type, String lexeme, int position) {
            this.type = type;
            this.text = lexeme;
            this.position = position;
        }

        String lexeme() {
            return this.text;
        }

        @Generated
        public String toString() {
            return "Xpath.Token(type=" + this.type + ", text=" + this.text + ", position=" + this.position + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (this.position != other.position) {
                return false;
            }
            Type this$type = this.type;
            Type other$type = other.type;
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$text = this.text;
            String other$text = other.text;
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.position;
            Type $type = this.type;
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $text = this.text;
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }
    }

    private static final class XPathLexer {
        private static final Pattern PATTERN = Type.pattern();
        private final String path;
        private final boolean trace;

        private XPathLexer(String path) {
            this.path = path;
            this.trace = false;
        }

        Stream<Token> tokens() {
            Matcher matcher = PATTERN.matcher(this.path);
            ArrayList<Token> tokens = new ArrayList<Token>(0);
            while (matcher.find()) {
                Type type = XPathLexer.type(matcher);
                String value = matcher.group();
                tokens.add(new Token(type, value, matcher.start()));
            }
            if (this.trace) {
                Logger logger = Logger.getLogger(XPathLexer.class.getSimpleName());
                logger.info("Tokens:");
                tokens.stream().map(Token::toString).forEach(logger::info);
            }
            return tokens.stream();
        }

        private static Type type(Matcher matcher) {
            for (Type type : Type.values()) {
                if (matcher.group(type.name()) == null) continue;
                return type;
            }
            throw new IllegalStateException(String.format("Unknown token type for %s", matcher.group()));
        }
    }

    private static final class OrExpression
    implements XpathFunction {
        private final XpathFunction left;
        private final XpathFunction right;

        private OrExpression(XpathFunction left, XpathFunction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object execute(Xml xml) {
            return Xpath.toBoolean(this.left.execute(xml)) || Xpath.toBoolean(this.right.execute(xml));
        }
    }

    private static final class AndExpression
    implements XpathFunction {
        private final XpathFunction left;
        private final XpathFunction right;

        private AndExpression(XpathFunction left, XpathFunction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object execute(Xml xml) {
            boolean first = Xpath.toBoolean(this.left.execute(xml));
            return first && Xpath.toBoolean(this.right.execute(xml));
        }
    }

    private static final class AttributeEqualityExperssion
    implements XpathFunction {
        private final String attribute;
        private final String value;

        private AttributeEqualityExperssion(String attribute, String value) {
            this.attribute = attribute;
            this.value = value;
        }

        @Override
        public Object execute(Xml xml) {
            return xml.attribute(this.attribute).map(Xml::text).filter(Optional::isPresent).map(Optional::get).map(v -> v.equals(this.value)).orElse(false);
        }
    }

    private static final class LtExpression
    implements XpathFunction {
        private final XpathFunction left;
        private final int right;

        private LtExpression(XpathFunction left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object execute(Xml xml) {
            return (Integer)this.left.execute(xml) < this.right;
        }
    }

    private static final class GtExpression
    implements XpathFunction {
        private final XpathFunction left;
        private final int right;

        private GtExpression(XpathFunction left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object execute(Xml xml) {
            return (Integer)this.left.execute(xml) > this.right;
        }
    }

    private static final class EqualityExpression
    implements XpathFunction {
        private final XpathFunction left;
        private final XpathFunction right;

        private EqualityExpression(XpathFunction left, XpathFunction right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object execute(Xml xml) {
            return this.left.execute(xml).equals(this.right.execute(xml));
        }
    }

    private static final class LiteralNumber
    implements XpathFunction {
        private final String number;

        private LiteralNumber(String number) {
            this.number = number;
        }

        @Override
        public Object execute(Xml xml) {
            return Integer.parseInt(this.number);
        }
    }

    private static final class LiteralString
    implements XpathFunction {
        private final String quoted;

        public LiteralString(String quoted) {
            this.quoted = quoted;
        }

        @Override
        public Object execute(Xml xml) {
            return this.quoted.substring(1, this.quoted.length() - 1);
        }
    }

    private static final class Text
    implements XpathFunction {
        private Text() {
        }

        @Override
        public String execute(Xml xml) {
            return xml.text().orElseThrow(() -> new IllegalStateException("Text not found"));
        }
    }

    private static final class NormalizeSpace
    implements XpathFunction {
        private final XpathFunction original;

        private NormalizeSpace(XpathFunction original) {
            this.original = original;
        }

        @Override
        public Object execute(Xml xml) {
            return String.valueOf(this.original.execute(xml)).trim().replaceAll(" +", " ");
        }
    }

    private static final class StringLength
    implements XpathFunction {
        private final XpathFunction original;

        private StringLength(XpathFunction original) {
            this.original = original;
        }

        @Override
        public Object execute(Xml xml) {
            return String.valueOf(this.original.execute(xml)).length();
        }
    }

    private static final class Not
    implements XpathFunction {
        private final XpathFunction original;

        private Not(XpathFunction original) {
            this.original = original;
        }

        @Override
        public Object execute(Xml xml) {
            return !Xpath.toBoolean(this.original.execute(xml));
        }
    }

    private static final class SubpathExpression
    implements XpathFunction {
        private final XpathNode subpath;

        private SubpathExpression(XpathNode subpath) {
            this.subpath = subpath;
        }

        @Override
        public Object execute(Xml xml) {
            return this.subpath.nodes(Stream.of(xml)).findFirst().orElse(new Empty());
        }

        public String toString() {
            return this.subpath.toString();
        }
    }

    private static final class SubpathTextExpression
    implements XpathFunction {
        private final XpathNode subpath;

        private SubpathTextExpression(XpathNode subpath) {
            this.subpath = subpath;
        }

        @Override
        public Object execute(Xml xml) {
            return this.subpath.nodes(Stream.of(xml)).map(Xml::text).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining());
        }
    }

    private static interface XpathFunction {
        public Object execute(Xml var1);
    }

    private static final class Traced
    implements XpathNode {
        private static final AtomicInteger TABS = new AtomicInteger(0);
        private static final Deque<String> STACK = new ArrayDeque<String>(0);
        private final XpathNode origin;

        private Traced(XpathNode origin) {
            this.origin = origin;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            Traced.print("{ '%s'", this.origin.toString());
            List collect = xml.collect(Collectors.toList());
            collect.stream().map(Objects::toString).map(Traced::clean).forEach(x$0 -> Traced.print(x$0, new Object[0]));
            this.inc();
            List after = this.origin.nodes(collect.stream()).collect(Collectors.toList());
            Traced.dec();
            if (!after.isEmpty()) {
                Traced.print("______", new Object[0]);
            }
            after.stream().map(Objects::toString).map(Traced::clean).forEach(x$0 -> Traced.print(x$0, new Object[0]));
            Traced.print("'%s' }", this.origin.toString());
            return after.stream();
        }

        public String toString() {
            return this.origin.toString();
        }

        private void inc() {
            TABS.incrementAndGet();
            STACK.push(this.origin.toString());
        }

        private static void dec() {
            TABS.decrementAndGet();
            STACK.pop();
        }

        private static String clean(String str) {
            return str.replaceAll("\n", "").replaceAll("\r", "").trim();
        }

        private static void print(String message, Object ... args) {
            Logger.getLogger(Traced.class.getSimpleName()).info(String.format("%s%s", " ".repeat(TABS.get()), String.format(message, args)));
        }
    }

    private static final class AttributeValueExpression
    implements XpathFunction {
        private final String name;

        private AttributeValueExpression(String name) {
            this.name = name;
        }

        @Override
        public Object execute(Xml xml) {
            return xml.attribute(this.name).orElse(new Empty());
        }

        public String toString() {
            return String.format("@%s", this.name);
        }
    }

    private static final class Attribute
    implements XpathNode {
        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            return xml.map(x -> x.attribute(this.name)).filter(Optional::isPresent).map(Optional::get);
        }

        @Generated
        public String toString() {
            return "Xpath.Attribute(name=" + this.name + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    private static final class NumberExpression
    implements XpathNode {
        private final XpathNode original;
        private final int index;

        private NumberExpression(XpathNode original, int index) {
            this.index = index;
            this.original = original;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            return this.original.nodes(xml).skip(this.index - 1).findFirst().stream();
        }

        public String toString() {
            return String.format("%s[%d]", this.original, this.index);
        }
    }

    private static final class Step
    implements XpathNode {
        private final String name;

        private Step(String name) {
            this.name = name;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            return xml.flatMap(Xml::children).filter(Filter.withName(this.name));
        }

        public String toString() {
            return String.format("step:%s", this.name);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    private static final class Predicated
    implements XpathNode {
        private final XpathNode original;
        private final XpathFunction predicate;

        private Predicated(XpathNode original, XpathFunction predicate) {
            this.original = original;
            this.predicate = predicate;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            return this.original.nodes(xml).filter(x -> Xpath.toBoolean(this.predicate.execute((Xml)x)));
        }

        public String toString() {
            return String.format("%s[%s]", this.original, this.predicate);
        }
    }

    private static final class RecursivePath
    implements XpathNode {
        private final XpathNode subpath;

        private RecursivePath(XpathNode path) {
            this.subpath = path;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            AtomicInteger integer = new AtomicInteger(0);
            Map<Xml, Integer> ordered = xml.flatMap(this::recursive).collect(Collectors.toMap(x -> x, x -> integer.incrementAndGet(), (a, ignore) -> a));
            return ordered.keySet().stream().flatMap(x -> this.subpath.nodes(Stream.of(x))).sorted(Comparator.comparingInt(ordered::get));
        }

        public String toString() {
            return String.format("rec://%s", this.subpath);
        }

        private Stream<Xml> recursive(Xml current) {
            return Stream.concat(Stream.of(current), current.children().flatMap(this::recursive));
        }
    }

    private static final class Sequence
    implements XpathNode {
        private final XpathNode first;
        private final XpathNode next;

        private Sequence(XpathNode first, XpathNode next) {
            this.first = first;
            this.next = next;
        }

        @Override
        public Stream<Xml> nodes(Stream<Xml> xml) {
            return this.next.nodes(this.first.nodes(xml));
        }
    }

    private static interface XpathNode {
        public Stream<Xml> nodes(Stream<Xml> var1);
    }

    private static final class StartsWithFunction
    implements XpathFunction {
        private final XpathFunction first;
        private final XpathFunction second;

        private StartsWithFunction(XpathFunction text, XpathFunction prefix) {
            this.first = text;
            this.second = prefix;
        }

        @Override
        public Object execute(Xml xml) {
            return Xpath.toString(this.first.execute(xml)).startsWith(Xpath.toString(this.second.execute(xml)));
        }

        public String toString() {
            return String.format("starts-with(%s, %s)", this.first, this.second);
        }
    }

    private static final class XPathParser {
        private final List<Token> tokens;
        private int pos;

        private XPathParser(Stream<Token> tokens) {
            this.tokens = tokens.collect(Collectors.toList());
            this.pos = 0;
        }

        XpathNode parsePath() {
            XpathNode step = x -> x;
            while (!this.eof()) {
                Token current = this.peek();
                if (current.type == Type.SLASH) {
                    this.consume(Type.SLASH);
                    step = new Sequence(step, this.parseStep());
                    continue;
                }
                if (current.type == Type.NAME) {
                    step = new Sequence(step, this.parseStep());
                    continue;
                }
                if (current.type == Type.DSLASH) {
                    this.consume(Type.DSLASH);
                    step = new Sequence(step, new RecursivePath(this.parsePath()));
                    continue;
                }
                if (current.type != Type.LPAREN) break;
                step = new Sequence(step, this.parseParenthesizedPath());
            }
            return step;
        }

        private XpathNode parseParenthesizedPath() {
            this.consume(Type.LPAREN);
            XpathNode step = this.parsePath();
            this.consume(Type.RPAREN);
            return this.parsePredicate(step);
        }

        private XpathNode parsePredicatedStep() {
            return this.parsePredicate(new Step(this.consume().lexeme()));
        }

        private XpathNode parsePredicate(XpathNode target) {
            XpathNode res = target;
            while (!this.eof() && this.peek().type == Type.LBRACKET) {
                this.consume(Type.LBRACKET);
                res = this.peek().type == Type.NUMBER ? new NumberExpression(res, Integer.parseInt(this.consume(Type.NUMBER).lexeme())) : new Predicated(res, this.parseExpression());
                this.consume(Type.RBRACKET);
            }
            return res;
        }

        private XpathNode parseStep() {
            XpathNode result;
            Token current = this.peek();
            if (current.type == Type.NAME) {
                result = this.parsePredicatedStep();
            } else if (current.type == Type.AT) {
                this.consume(Type.AT);
                result = new Attribute(this.consume().text);
            } else {
                throw new IllegalStateException(String.format("Expected one more step, but got %s", current));
            }
            return result;
        }

        private XpathFunction parseExpression() {
            Type current;
            XpathFunction left = this.parseSingleExpression();
            while (!(this.eof() || (current = this.peek().type) != Type.AND && current != Type.OR && current != Type.EQUALS)) {
                Token token = this.consume();
                if (token.type == Type.AND) {
                    left = new AndExpression(left, this.parseExpression());
                    continue;
                }
                if (token.type == Type.OR) {
                    left = new OrExpression(left, this.parseExpression());
                    continue;
                }
                if (token.type == Type.EQUALS) {
                    left = new EqualityExpression(left, this.parseExpression());
                    continue;
                }
                throw new IllegalStateException(String.format("Expected AND or OR, but got %s", token));
            }
            return left;
        }

        private XpathFunction parseSingleExpression() {
            XpathFunction result;
            Token current = this.peek();
            if (current.type == Type.AT) {
                this.consume(Type.AT);
                result = this.parseAttributeExpression();
            } else if (current.type == Type.NAME) {
                result = this.parseNamedClause();
            } else if (current.type == Type.LPAREN) {
                this.consume(Type.LPAREN);
                XpathFunction expr = this.parseExpression();
                this.consume(Type.RPAREN);
                result = expr;
            } else if (current.type == Type.VALUE) {
                result = new LiteralString(this.consume().text);
            } else if (current.type == Type.NUMBER) {
                result = new LiteralNumber(this.consume().text);
            } else {
                throw new IllegalStateException(String.format("Unexpected token in the expression '%s'", current));
            }
            return result;
        }

        private XpathFunction parseNamedClause() {
            XpathFunction result;
            if (this.peek().type == Type.NAME) {
                Type next = this.tokens.get((int)(this.pos + 1)).type;
                if (next == Type.LPAREN) {
                    result = this.parseFunction();
                } else if (next == Type.EQUALS) {
                    SubpathTextExpression path = new SubpathTextExpression(this.parsePath());
                    result = this.parseEqExpression(path);
                } else {
                    result = new SubpathExpression(this.parsePath());
                }
            } else {
                throw new IllegalStateException(String.format("Expected name, but got %s", this.peek()));
            }
            return result;
        }

        private XpathFunction parseFunction() {
            XpathFunction arg;
            XpathFunction function;
            Token token = this.consume();
            String name = token.text;
            if ("text".equals(name)) {
                this.consume(Type.LPAREN);
                this.consume(Type.RPAREN);
                function = new Text();
            } else if ("not".equals(name)) {
                this.consume(Type.LPAREN);
                XpathFunction original = this.parseExpression();
                this.consume(Type.RPAREN);
                function = new Not(original);
            } else if ("string-length".equals(name)) {
                this.consume(Type.LPAREN);
                arg = this.parseExpression();
                this.consume(Type.RPAREN);
                function = new StringLength(arg);
            } else if ("normalize-space".equals(name)) {
                this.consume(Type.LPAREN);
                arg = this.parseExpression();
                this.consume(Type.RPAREN);
                function = new NormalizeSpace(arg);
            } else if ("starts-with".equals(name)) {
                this.consume(Type.LPAREN);
                XpathFunction arg1 = this.parseExpression();
                this.consume(Type.COMMA);
                XpathFunction arg2 = this.parseExpression();
                this.consume(Type.RPAREN);
                function = new StartsWithFunction(arg1, arg2);
            } else {
                throw new IllegalStateException(String.format("Unknown function '%s'", name));
            }
            XpathFunction res = this.peek().type == Type.EQUALS ? this.parseEqExpression(function) : (this.peek().type == Type.GT ? this.parseGtExpression(function) : (this.peek().type == Type.LT ? this.parseLtExpression(function) : function));
            return res;
        }

        private XpathFunction parseLtExpression(XpathFunction result) {
            Token less = this.consume(Type.LT);
            if (less.type != Type.LT) {
                throw new IllegalStateException(String.format("Expected '<', but got %s", less));
            }
            LtExpression res = new LtExpression(result, Integer.parseInt(this.consume((Type)Type.NUMBER).text));
            return res;
        }

        private XpathFunction parseGtExpression(XpathFunction result) {
            Token great = this.consume(Type.GT);
            if (great.type == Type.GT) {
                return new GtExpression(result, Integer.parseInt(this.consume((Type)Type.NUMBER).text));
            }
            throw new IllegalStateException(String.format("Expected '>', but got %s", great));
        }

        private XpathFunction parseEqExpression(XpathFunction original) {
            XpathFunction comparable;
            this.consume(Type.EQUALS);
            Token value = this.consume();
            if (value.type == Type.VALUE) {
                comparable = new LiteralString(value.text);
            } else if (value.type == Type.NUMBER) {
                comparable = new LiteralNumber(value.text);
            } else {
                throw new IllegalStateException(String.format("Expected a value or a number, but got %s", value));
            }
            return new EqualityExpression(original, comparable);
        }

        private XpathFunction parseAttributeExpression() {
            XpathFunction result;
            Token name = this.consume(Type.NAME);
            if (this.eof() || this.tokens.get((int)this.pos).type != Type.EQUALS) {
                result = new AttributeValueExpression(name.text);
            } else {
                this.consume(Type.EQUALS);
                Token value = this.consume(Type.VALUE);
                result = new AttributeEqualityExperssion(name.text, value.text.substring(1, value.text.length() - 1));
            }
            return result;
        }

        private Token consume(Type type) {
            Token consumed = this.consume();
            if (consumed.type != type) {
                throw new IllegalStateException(String.format("Expected '%s', but got '%s' in position: %d", type.subpattern.replaceAll("\\\\", ""), consumed.text, consumed.position));
            }
            return consumed;
        }

        private Token consume() {
            Token token = this.tokens.get(this.pos);
            ++this.pos;
            return token;
        }

        private Token peek() {
            return this.tokens.get(this.pos);
        }

        private boolean eof() {
            return this.pos >= this.tokens.size();
        }
    }
}

