/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.xnav;

import com.github.lombrozo.xnav.Xml;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Filter
extends Predicate<Xml> {
    @Override
    public boolean test(Xml var1);

    public static Filter all(Filter ... filters) {
        Filter result = filters.length == 0 ? xml -> true : xml -> Stream.of(filters).allMatch(filter -> filter.test(xml));
        return result;
    }

    public static Filter any(Filter ... filters) {
        Filter result = filters.length == 0 ? xml -> true : xml -> Stream.of(filters).anyMatch(filter -> filter.test(xml));
        return result;
    }

    public static Filter withName(String name) {
        return xml -> xml.name().equals(name);
    }

    public static Filter withAttribute(String name, String value) {
        return xml -> xml.attribute(name).map(Xml::text).filter(Optional::isPresent).map(Optional::get).map(val -> val.equals(value)).orElse(false);
    }

    public static Filter hasAttribute(String name) {
        return xml -> xml.attribute(name).isPresent();
    }

    public static Filter not(Filter filter) {
        return xml -> !filter.test(xml);
    }
}

