/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.xnav;

import com.github.lombrozo.xnav.DomXml;
import com.github.lombrozo.xnav.Empty;
import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xml;
import com.github.lombrozo.xnav.Xpath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.w3c.dom.Node;

public final class Xnav {
    private final Xml xml;

    public Xnav(Path file) {
        this(Xnav.from(file));
    }

    public Xnav(File file) {
        this(Xnav.from(file.toPath()));
    }

    public Xnav(String ... join) {
        this(new DomXml(String.join((CharSequence)"\n", join)));
    }

    public Xnav(Node node) {
        this(new DomXml(node));
    }

    public Xnav(Xml xml) {
        this.xml = xml;
    }

    public Xnav element(String name) {
        return new Xnav(this.xml.child(name));
    }

    public Stream<Xnav> elements(Filter ... filters) {
        return this.xml.children().filter(Filter.all(filters)).map(Xnav::new);
    }

    public Stream<Xnav> strict(int number) {
        List collect = this.xml.children().collect(Collectors.toList());
        if (collect.size() == number) {
            return collect.stream().map(Xnav::new);
        }
        throw new IllegalStateException(String.format("Expected %d child nodes, but found %d", number, collect.size()));
    }

    public Stream<Xnav> strict(String path, int number) {
        List all = this.path(path).collect(Collectors.toList());
        if (all.size() == number) {
            return all.stream();
        }
        throw new IllegalStateException(String.format("Expected %d child nodes, but found %d", number, all.size()));
    }

    public Xnav one() {
        return this.strict(1).findFirst().orElseThrow();
    }

    public Xnav one(String xpath) {
        return this.strict(xpath, 1).findFirst().orElseThrow();
    }

    public Xnav attribute(String name) {
        return new Xnav(this.xml.attribute(name).orElseGet(Empty::new));
    }

    public Stream<Xnav> path(String path) {
        return new Xpath(this.xml, path).nodes().map(Xnav::new);
    }

    public Xnav copy() {
        return new Xnav(this.xml.copy());
    }

    public Optional<String> text() {
        return this.xml.text();
    }

    public Node node() {
        return this.xml.node();
    }

    private static Xml from(Path file) {
        try {
            return new DomXml(Files.readString(file));
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Failed to read file '%s'", file), exception);
        }
    }

    @Generated
    public String toString() {
        return "Xnav(xml=" + String.valueOf(this.xml) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xnav)) {
            return false;
        }
        Xnav other = (Xnav)o;
        Xml this$xml = this.xml;
        Xml other$xml = other.xml;
        return !(this$xml == null ? other$xml != null : !this$xml.equals(other$xml));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Xml $xml = this.xml;
        result = result * 59 + ($xml == null ? 43 : $xml.hashCode());
        return result;
    }
}

