/*
 * Decompiled with CFR 0.152.
 */
package com.creative.studio.component.dependency.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class DependencyResolverVisitor
implements DependencyNodeVisitor {
    protected final Map<String, Artifact> resolvedDependenciesByName = new TreeMap<String, Artifact>();
    protected final Map<String, List<Artifact>> conflictDependencyArtifacts = new TreeMap<String, List<Artifact>>();

    public boolean endVisit(DependencyNode node) {
        return true;
    }

    private String getQualifiedName(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType();
    }

    public boolean visit(DependencyNode node) {
        Artifact at = node.getArtifact();
        int state = node.getState();
        String key = this.getQualifiedName(at);
        switch (state) {
            case 0: {
                this.resolvedDependenciesByName.put(key, at);
                break;
            }
            case 2: {
                DefaultArtifactVersion dav1 = new DefaultArtifactVersion(node.getArtifact().getVersion());
                DefaultArtifactVersion dav2 = new DefaultArtifactVersion(node.getRelatedArtifact().getVersion());
                if (!this.isIncompatible(dav1, dav2)) break;
                if (this.conflictDependencyArtifacts.containsKey(key)) {
                    this.conflictDependencyArtifacts.get(key).add(at);
                    this.conflictDependencyArtifacts.get(key).add(node.getRelatedArtifact());
                    break;
                }
                ArrayList<Artifact> ats = new ArrayList<Artifact>();
                ats.add(at);
                if (!key.equals(this.getQualifiedName(node.getRelatedArtifact()))) {
                    ats.add(node.getRelatedArtifact());
                }
                this.conflictDependencyArtifacts.put(key, ats);
            }
        }
        return true;
    }

    private boolean isIncompatible(DefaultArtifactVersion dav1, DefaultArtifactVersion dav2) {
        return dav1.getMajorVersion() > dav2.getMajorVersion() || dav1.getMajorVersion() == dav2.getMajorVersion() && dav1.getMinorVersion() > dav2.getMinorVersion();
    }

    public Map<String, Artifact> getResolvedDependenciesByName() {
        return this.resolvedDependenciesByName;
    }

    public Map<String, List<Artifact>> getConflictDependencyArtifacts() {
        return this.conflictDependencyArtifacts;
    }
}

