/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.Barrier;
import com.github.vonrosen.quantlib.Exercise;
import com.github.vonrosen.quantlib.GeneralizedBlackScholesProcess;
import com.github.vonrosen.quantlib.Instrument;
import com.github.vonrosen.quantlib.Payoff;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.SampledCurve;

public class BarrierOption
extends Instrument {
    private transient long swigCPtr;

    protected BarrierOption(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.BarrierOption_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BarrierOption obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_BarrierOption(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public BarrierOption(Barrier.Type barrierType, double barrier, double rebate, Payoff payoff, Exercise exercise) {
        this(QuantLibJNI.new_BarrierOption(barrierType.swigValue(), barrier, rebate, Payoff.getCPtr(payoff), payoff, Exercise.getCPtr(exercise), exercise), true);
    }

    public SampledCurve priceCurve() {
        return new SampledCurve(QuantLibJNI.BarrierOption_priceCurve(this.swigCPtr, this), true);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI.BarrierOption_impliedVolatility__SWIG_0(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations, double minVol) {
        return QuantLibJNI.BarrierOption_impliedVolatility__SWIG_1(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations, minVol);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations) {
        return QuantLibJNI.BarrierOption_impliedVolatility__SWIG_2(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy) {
        return QuantLibJNI.BarrierOption_impliedVolatility__SWIG_3(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process) {
        return QuantLibJNI.BarrierOption_impliedVolatility__SWIG_4(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process);
    }

    public double delta() {
        return QuantLibJNI.BarrierOption_delta(this.swigCPtr, this);
    }

    public double gamma() {
        return QuantLibJNI.BarrierOption_gamma(this.swigCPtr, this);
    }

    public double theta() {
        return QuantLibJNI.BarrierOption_theta(this.swigCPtr, this);
    }

    public double thetaPerDay() {
        return QuantLibJNI.BarrierOption_thetaPerDay(this.swigCPtr, this);
    }

    public double vega() {
        return QuantLibJNI.BarrierOption_vega(this.swigCPtr, this);
    }

    public double rho() {
        return QuantLibJNI.BarrierOption_rho(this.swigCPtr, this);
    }

    public double dividendRho() {
        return QuantLibJNI.BarrierOption_dividendRho(this.swigCPtr, this);
    }

    public double strikeSensitivity() {
        return QuantLibJNI.BarrierOption_strikeSensitivity(this.swigCPtr, this);
    }
}

