/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.Payoff;
import com.github.vonrosen.quantlib.QuantLibJNI;

public class BlackCalculator {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected BlackCalculator(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BlackCalculator obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_BlackCalculator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public BlackCalculator(Payoff payoff, double forward, double stdDev, double discount) {
        this(QuantLibJNI.new_BlackCalculator__SWIG_0(Payoff.getCPtr(payoff), payoff, forward, stdDev, discount), true);
    }

    public BlackCalculator(Payoff payoff, double forward, double stdDev) {
        this(QuantLibJNI.new_BlackCalculator__SWIG_1(Payoff.getCPtr(payoff), payoff, forward, stdDev), true);
    }

    public double value() {
        return QuantLibJNI.BlackCalculator_value(this.swigCPtr, this);
    }

    public double deltaForward() {
        return QuantLibJNI.BlackCalculator_deltaForward(this.swigCPtr, this);
    }

    public double delta(double spot) {
        return QuantLibJNI.BlackCalculator_delta(this.swigCPtr, this, spot);
    }

    public double elasticityForward() {
        return QuantLibJNI.BlackCalculator_elasticityForward(this.swigCPtr, this);
    }

    public double elasticity(double spot) {
        return QuantLibJNI.BlackCalculator_elasticity(this.swigCPtr, this, spot);
    }

    public double gammaForward() {
        return QuantLibJNI.BlackCalculator_gammaForward(this.swigCPtr, this);
    }

    public double gamma(double spot) {
        return QuantLibJNI.BlackCalculator_gamma(this.swigCPtr, this, spot);
    }

    public double theta(double spot, double maturity) {
        return QuantLibJNI.BlackCalculator_theta(this.swigCPtr, this, spot, maturity);
    }

    public double thetaPerDay(double spot, double maturity) {
        return QuantLibJNI.BlackCalculator_thetaPerDay(this.swigCPtr, this, spot, maturity);
    }

    public double vega(double maturity) {
        return QuantLibJNI.BlackCalculator_vega(this.swigCPtr, this, maturity);
    }

    public double rho(double maturity) {
        return QuantLibJNI.BlackCalculator_rho(this.swigCPtr, this, maturity);
    }

    public double dividendRho(double maturity) {
        return QuantLibJNI.BlackCalculator_dividendRho(this.swigCPtr, this, maturity);
    }

    public double itmCashProbability() {
        return QuantLibJNI.BlackCalculator_itmCashProbability(this.swigCPtr, this);
    }

    public double itmAssetProbability() {
        return QuantLibJNI.BlackCalculator_itmAssetProbability(this.swigCPtr, this);
    }

    public double strikeSensitivity() {
        return QuantLibJNI.BlackCalculator_strikeSensitivity(this.swigCPtr, this);
    }

    public double alpha() {
        return QuantLibJNI.BlackCalculator_alpha(this.swigCPtr, this);
    }

    public double beta() {
        return QuantLibJNI.BlackCalculator_beta(this.swigCPtr, this);
    }
}

