/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.BusinessDayConvention;
import com.github.vonrosen.quantlib.Date;
import com.github.vonrosen.quantlib.Period;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.TimeUnit;
import com.github.vonrosen.quantlib.Weekday;

public class Calendar {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Calendar(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Calendar obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_Calendar(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean isWeekend(Weekday w) {
        return QuantLibJNI.Calendar_isWeekend(this.swigCPtr, this, w.swigValue());
    }

    public Date endOfMonth(Date arg0) {
        return new Date(QuantLibJNI.Calendar_endOfMonth(this.swigCPtr, this, Date.getCPtr(arg0), arg0), true);
    }

    public boolean isBusinessDay(Date arg0) {
        return QuantLibJNI.Calendar_isBusinessDay(this.swigCPtr, this, Date.getCPtr(arg0), arg0);
    }

    public boolean isHoliday(Date arg0) {
        return QuantLibJNI.Calendar_isHoliday(this.swigCPtr, this, Date.getCPtr(arg0), arg0);
    }

    public boolean isEndOfMonth(Date arg0) {
        return QuantLibJNI.Calendar_isEndOfMonth(this.swigCPtr, this, Date.getCPtr(arg0), arg0);
    }

    public void addHoliday(Date arg0) {
        QuantLibJNI.Calendar_addHoliday(this.swigCPtr, this, Date.getCPtr(arg0), arg0);
    }

    public void removeHoliday(Date arg0) {
        QuantLibJNI.Calendar_removeHoliday(this.swigCPtr, this, Date.getCPtr(arg0), arg0);
    }

    public Date adjust(Date d, BusinessDayConvention convention) {
        return new Date(QuantLibJNI.Calendar_adjust__SWIG_0(this.swigCPtr, this, Date.getCPtr(d), d, convention.swigValue()), true);
    }

    public Date adjust(Date d) {
        return new Date(QuantLibJNI.Calendar_adjust__SWIG_1(this.swigCPtr, this, Date.getCPtr(d), d), true);
    }

    public Date advance(Date d, int n, TimeUnit unit, BusinessDayConvention convention, boolean endOfMonth) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_0(this.swigCPtr, this, Date.getCPtr(d), d, n, unit.swigValue(), convention.swigValue(), endOfMonth), true);
    }

    public Date advance(Date d, int n, TimeUnit unit, BusinessDayConvention convention) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_1(this.swigCPtr, this, Date.getCPtr(d), d, n, unit.swigValue(), convention.swigValue()), true);
    }

    public Date advance(Date d, int n, TimeUnit unit) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_2(this.swigCPtr, this, Date.getCPtr(d), d, n, unit.swigValue()), true);
    }

    public Date advance(Date d, Period period, BusinessDayConvention convention, boolean endOfMonth) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_3(this.swigCPtr, this, Date.getCPtr(d), d, Period.getCPtr(period), period, convention.swigValue(), endOfMonth), true);
    }

    public Date advance(Date d, Period period, BusinessDayConvention convention) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_4(this.swigCPtr, this, Date.getCPtr(d), d, Period.getCPtr(period), period, convention.swigValue()), true);
    }

    public Date advance(Date d, Period period) {
        return new Date(QuantLibJNI.Calendar_advance__SWIG_5(this.swigCPtr, this, Date.getCPtr(d), d, Period.getCPtr(period), period), true);
    }

    public int businessDaysBetween(Date from, Date to, boolean includeFirst, boolean includeLast) {
        return QuantLibJNI.Calendar_businessDaysBetween__SWIG_0(this.swigCPtr, this, Date.getCPtr(from), from, Date.getCPtr(to), to, includeFirst, includeLast);
    }

    public int businessDaysBetween(Date from, Date to, boolean includeFirst) {
        return QuantLibJNI.Calendar_businessDaysBetween__SWIG_1(this.swigCPtr, this, Date.getCPtr(from), from, Date.getCPtr(to), to, includeFirst);
    }

    public int businessDaysBetween(Date from, Date to) {
        return QuantLibJNI.Calendar_businessDaysBetween__SWIG_2(this.swigCPtr, this, Date.getCPtr(from), from, Date.getCPtr(to), to);
    }

    public String name() {
        return QuantLibJNI.Calendar_name(this.swigCPtr, this);
    }

    public String toString() {
        return QuantLibJNI.Calendar_toString(this.swigCPtr, this);
    }

    public boolean equals(Calendar other) {
        return QuantLibJNI.Calendar_equals(this.swigCPtr, this, Calendar.getCPtr(other), other);
    }

    public boolean unEquals(Calendar other) {
        return QuantLibJNI.Calendar_unEquals(this.swigCPtr, this, Calendar.getCPtr(other), other);
    }
}

