/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.BusinessDayConvention;
import com.github.vonrosen.quantlib.DayCounter;
import com.github.vonrosen.quantlib.Instrument;
import com.github.vonrosen.quantlib.Leg;
import com.github.vonrosen.quantlib.Protection;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.Schedule;
import com.github.vonrosen.quantlib.YieldTermStructureHandle;

public class CreditDefaultSwap
extends Instrument {
    private transient long swigCPtr;

    protected CreditDefaultSwap(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.CreditDefaultSwap_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CreditDefaultSwap obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_CreditDefaultSwap(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter, boolean settlesAccrual, boolean paysAtDefaultTime) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_0(side.swigValue(), notional, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter, settlesAccrual, paysAtDefaultTime), true);
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter, boolean settlesAccrual) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_1(side.swigValue(), notional, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter, settlesAccrual), true);
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_2(side.swigValue(), notional, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter), true);
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double upfront, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter, boolean settlesAccrual, boolean paysAtDefaultTime) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_3(side.swigValue(), notional, upfront, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter, settlesAccrual, paysAtDefaultTime), true);
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double upfront, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter, boolean settlesAccrual) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_4(side.swigValue(), notional, upfront, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter, settlesAccrual), true);
    }

    public CreditDefaultSwap(Protection.Side side, double notional, double upfront, double spread, Schedule schedule, BusinessDayConvention paymentConvention, DayCounter dayCounter) {
        this(QuantLibJNI.new_CreditDefaultSwap__SWIG_5(side.swigValue(), notional, upfront, spread, Schedule.getCPtr(schedule), schedule, paymentConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter), true);
    }

    public Protection.Side side() {
        return Protection.Side.swigToEnum(QuantLibJNI.CreditDefaultSwap_side(this.swigCPtr, this));
    }

    public double notional() {
        return QuantLibJNI.CreditDefaultSwap_notional(this.swigCPtr, this);
    }

    public double runningSpread() {
        return QuantLibJNI.CreditDefaultSwap_runningSpread(this.swigCPtr, this);
    }

    public double upfront() {
        return QuantLibJNI.CreditDefaultSwap_upfront(this.swigCPtr, this);
    }

    public boolean settlesAccrual() {
        return QuantLibJNI.CreditDefaultSwap_settlesAccrual(this.swigCPtr, this);
    }

    public boolean paysAtDefaultTime() {
        return QuantLibJNI.CreditDefaultSwap_paysAtDefaultTime(this.swigCPtr, this);
    }

    public double fairSpread() {
        return QuantLibJNI.CreditDefaultSwap_fairSpread(this.swigCPtr, this);
    }

    public double fairUpfront() {
        return QuantLibJNI.CreditDefaultSwap_fairUpfront(this.swigCPtr, this);
    }

    public double couponLegBPS() {
        return QuantLibJNI.CreditDefaultSwap_couponLegBPS(this.swigCPtr, this);
    }

    public double couponLegNPV() {
        return QuantLibJNI.CreditDefaultSwap_couponLegNPV(this.swigCPtr, this);
    }

    public double defaultLegNPV() {
        return QuantLibJNI.CreditDefaultSwap_defaultLegNPV(this.swigCPtr, this);
    }

    public double upfrontBPS() {
        return QuantLibJNI.CreditDefaultSwap_upfrontBPS(this.swigCPtr, this);
    }

    public double upfrontNPV() {
        return QuantLibJNI.CreditDefaultSwap_upfrontNPV(this.swigCPtr, this);
    }

    public double impliedHazardRate(double targetNPV, YieldTermStructureHandle discountCurve, DayCounter dayCounter, double recoveryRate, double accuracy) {
        return QuantLibJNI.CreditDefaultSwap_impliedHazardRate__SWIG_0(this.swigCPtr, this, targetNPV, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, DayCounter.getCPtr(dayCounter), dayCounter, recoveryRate, accuracy);
    }

    public double impliedHazardRate(double targetNPV, YieldTermStructureHandle discountCurve, DayCounter dayCounter, double recoveryRate) {
        return QuantLibJNI.CreditDefaultSwap_impliedHazardRate__SWIG_1(this.swigCPtr, this, targetNPV, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, DayCounter.getCPtr(dayCounter), dayCounter, recoveryRate);
    }

    public double impliedHazardRate(double targetNPV, YieldTermStructureHandle discountCurve, DayCounter dayCounter) {
        return QuantLibJNI.CreditDefaultSwap_impliedHazardRate__SWIG_2(this.swigCPtr, this, targetNPV, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, DayCounter.getCPtr(dayCounter), dayCounter);
    }

    public Leg coupons() {
        return new Leg(QuantLibJNI.CreditDefaultSwap_coupons(this.swigCPtr, this), true);
    }
}

