/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.Coupon;
import com.github.vonrosen.quantlib.Date;
import com.github.vonrosen.quantlib.FloatingRateCouponPricer;
import com.github.vonrosen.quantlib.InterestRateIndex;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.YieldTermStructureHandle;

public class FloatingRateCoupon
extends Coupon {
    private transient long swigCPtr;

    protected FloatingRateCoupon(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.FloatingRateCoupon_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FloatingRateCoupon obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_FloatingRateCoupon(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Date fixingDate() {
        return new Date(QuantLibJNI.FloatingRateCoupon_fixingDate(this.swigCPtr, this), true);
    }

    public int fixingDays() {
        return QuantLibJNI.FloatingRateCoupon_fixingDays(this.swigCPtr, this);
    }

    public boolean isInArrears() {
        return QuantLibJNI.FloatingRateCoupon_isInArrears(this.swigCPtr, this);
    }

    public double gearing() {
        return QuantLibJNI.FloatingRateCoupon_gearing(this.swigCPtr, this);
    }

    public double spread() {
        return QuantLibJNI.FloatingRateCoupon_spread(this.swigCPtr, this);
    }

    public double indexFixing() {
        return QuantLibJNI.FloatingRateCoupon_indexFixing(this.swigCPtr, this);
    }

    public double adjustedFixing() {
        return QuantLibJNI.FloatingRateCoupon_adjustedFixing(this.swigCPtr, this);
    }

    public double convexityAdjustment() {
        return QuantLibJNI.FloatingRateCoupon_convexityAdjustment(this.swigCPtr, this);
    }

    public double price(YieldTermStructureHandle discountCurve) {
        return QuantLibJNI.FloatingRateCoupon_price(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve);
    }

    public InterestRateIndex index() {
        return new InterestRateIndex(QuantLibJNI.FloatingRateCoupon_index(this.swigCPtr, this), true);
    }

    public void setPricer(FloatingRateCouponPricer p) {
        QuantLibJNI.FloatingRateCoupon_setPricer(this.swigCPtr, this, FloatingRateCouponPricer.getCPtr(p), p);
    }
}

