/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.DoubleVector;
import com.github.vonrosen.quantlib.QuantLibJNI;

public class IncrementalStatistics {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IncrementalStatistics(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IncrementalStatistics obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_IncrementalStatistics(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public long samples() {
        return QuantLibJNI.IncrementalStatistics_samples(this.swigCPtr, this);
    }

    public double weightSum() {
        return QuantLibJNI.IncrementalStatistics_weightSum(this.swigCPtr, this);
    }

    public double mean() {
        return QuantLibJNI.IncrementalStatistics_mean(this.swigCPtr, this);
    }

    public double variance() {
        return QuantLibJNI.IncrementalStatistics_variance(this.swigCPtr, this);
    }

    public double standardDeviation() {
        return QuantLibJNI.IncrementalStatistics_standardDeviation(this.swigCPtr, this);
    }

    public double errorEstimate() {
        return QuantLibJNI.IncrementalStatistics_errorEstimate(this.swigCPtr, this);
    }

    public double skewness() {
        return QuantLibJNI.IncrementalStatistics_skewness(this.swigCPtr, this);
    }

    public double kurtosis() {
        return QuantLibJNI.IncrementalStatistics_kurtosis(this.swigCPtr, this);
    }

    public double min() {
        return QuantLibJNI.IncrementalStatistics_min(this.swigCPtr, this);
    }

    public double max() {
        return QuantLibJNI.IncrementalStatistics_max(this.swigCPtr, this);
    }

    public void reset() {
        QuantLibJNI.IncrementalStatistics_reset(this.swigCPtr, this);
    }

    public void add(double value, double weight) {
        QuantLibJNI.IncrementalStatistics_add__SWIG_0(this.swigCPtr, this, value, weight);
    }

    public void add(double value) {
        QuantLibJNI.IncrementalStatistics_add__SWIG_1(this.swigCPtr, this, value);
    }

    public void add(DoubleVector values) {
        QuantLibJNI.IncrementalStatistics_add__SWIG_2(this.swigCPtr, this, DoubleVector.getCPtr(values), values);
    }

    public void add(DoubleVector values, DoubleVector weights) {
        QuantLibJNI.IncrementalStatistics_add__SWIG_3(this.swigCPtr, this, DoubleVector.getCPtr(values), values, DoubleVector.getCPtr(weights), weights);
    }

    public IncrementalStatistics() {
        this(QuantLibJNI.new_IncrementalStatistics(), true);
    }
}

