/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.DateVector;
import com.github.vonrosen.quantlib.DoubleVector;
import com.github.vonrosen.quantlib.IntervalPriceTimeSeries;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.RealTimeSeries;

public class IntervalPrice {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntervalPrice(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IntervalPrice obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_IntervalPrice(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IntervalPrice(double arg0, double arg1, double arg2, double arg3) {
        this(QuantLibJNI.new_IntervalPrice(arg0, arg1, arg2, arg3), true);
    }

    public void setValue(double arg0, Type arg1) {
        QuantLibJNI.IntervalPrice_setValue(this.swigCPtr, this, arg0, arg1.swigValue());
    }

    public void setValues(double arg0, double arg1, double arg2, double arg3) {
        QuantLibJNI.IntervalPrice_setValues(this.swigCPtr, this, arg0, arg1, arg2, arg3);
    }

    public double value(Type t) {
        return QuantLibJNI.IntervalPrice_value(this.swigCPtr, this, t.swigValue());
    }

    public double open() {
        return QuantLibJNI.IntervalPrice_open(this.swigCPtr, this);
    }

    public double close() {
        return QuantLibJNI.IntervalPrice_close(this.swigCPtr, this);
    }

    public double high() {
        return QuantLibJNI.IntervalPrice_high(this.swigCPtr, this);
    }

    public double low() {
        return QuantLibJNI.IntervalPrice_low(this.swigCPtr, this);
    }

    public static IntervalPriceTimeSeries makeSeries(DateVector d, DoubleVector open, DoubleVector close, DoubleVector high, DoubleVector low) {
        return new IntervalPriceTimeSeries(QuantLibJNI.IntervalPrice_makeSeries(DateVector.getCPtr(d), d, DoubleVector.getCPtr(open), open, DoubleVector.getCPtr(close), close, DoubleVector.getCPtr(high), high, DoubleVector.getCPtr(low), low), true);
    }

    public static DoubleVector extractValues(IntervalPriceTimeSeries arg0, Type t) {
        return new DoubleVector(QuantLibJNI.IntervalPrice_extractValues(IntervalPriceTimeSeries.getCPtr(arg0), arg0, t.swigValue()), true);
    }

    public static RealTimeSeries extractComponent(IntervalPriceTimeSeries arg0, Type t) {
        return new RealTimeSeries(QuantLibJNI.IntervalPrice_extractComponent(IntervalPriceTimeSeries.getCPtr(arg0), arg0, t.swigValue()), true);
    }

    public static final class Type {
        public static final Type Open = new Type("Open");
        public static final Type Close = new Type("Close");
        public static final Type High = new Type("High");
        public static final Type Low = new Type("Low");
        private static Type[] swigValues = new Type[]{Open, Close, High, Low};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

