/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.Array;
import com.github.vonrosen.quantlib.DoubleVector;
import com.github.vonrosen.quantlib.Matrix;
import com.github.vonrosen.quantlib.QuantLibJNI;

public class SequenceStatistics {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected SequenceStatistics(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SequenceStatistics obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_SequenceStatistics(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public SequenceStatistics(long dimension) {
        this(QuantLibJNI.new_SequenceStatistics(dimension), true);
    }

    public long size() {
        return QuantLibJNI.SequenceStatistics_size(this.swigCPtr, this);
    }

    public long samples() {
        return QuantLibJNI.SequenceStatistics_samples(this.swigCPtr, this);
    }

    public double weightSum() {
        return QuantLibJNI.SequenceStatistics_weightSum(this.swigCPtr, this);
    }

    public DoubleVector mean() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_mean(this.swigCPtr, this), true);
    }

    public DoubleVector variance() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_variance(this.swigCPtr, this), true);
    }

    public DoubleVector standardDeviation() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_standardDeviation(this.swigCPtr, this), true);
    }

    public DoubleVector errorEstimate() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_errorEstimate(this.swigCPtr, this), true);
    }

    public DoubleVector skewness() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_skewness(this.swigCPtr, this), true);
    }

    public DoubleVector kurtosis() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_kurtosis(this.swigCPtr, this), true);
    }

    public DoubleVector min() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_min(this.swigCPtr, this), true);
    }

    public DoubleVector max() {
        return new DoubleVector(QuantLibJNI.SequenceStatistics_max(this.swigCPtr, this), true);
    }

    public Matrix covariance() {
        return new Matrix(QuantLibJNI.SequenceStatistics_covariance(this.swigCPtr, this), true);
    }

    public Matrix correlation() {
        return new Matrix(QuantLibJNI.SequenceStatistics_correlation(this.swigCPtr, this), true);
    }

    public void reset() {
        QuantLibJNI.SequenceStatistics_reset(this.swigCPtr, this);
    }

    public void add(DoubleVector value, double weight) {
        QuantLibJNI.SequenceStatistics_add__SWIG_0(this.swigCPtr, this, DoubleVector.getCPtr(value), value, weight);
    }

    public void add(DoubleVector value) {
        QuantLibJNI.SequenceStatistics_add__SWIG_1(this.swigCPtr, this, DoubleVector.getCPtr(value), value);
    }

    public void add(Array value, double weight) {
        QuantLibJNI.SequenceStatistics_add__SWIG_2(this.swigCPtr, this, Array.getCPtr(value), value, weight);
    }

    public void add(Array value) {
        QuantLibJNI.SequenceStatistics_add__SWIG_3(this.swigCPtr, this, Array.getCPtr(value), value);
    }
}

