/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.DoubleVector;
import com.github.vonrosen.quantlib.QuantLibJNI;

public class Statistics {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Statistics(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Statistics obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_Statistics(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public long samples() {
        return QuantLibJNI.Statistics_samples(this.swigCPtr, this);
    }

    public double weightSum() {
        return QuantLibJNI.Statistics_weightSum(this.swigCPtr, this);
    }

    public double mean() {
        return QuantLibJNI.Statistics_mean(this.swigCPtr, this);
    }

    public double variance() {
        return QuantLibJNI.Statistics_variance(this.swigCPtr, this);
    }

    public double standardDeviation() {
        return QuantLibJNI.Statistics_standardDeviation(this.swigCPtr, this);
    }

    public double errorEstimate() {
        return QuantLibJNI.Statistics_errorEstimate(this.swigCPtr, this);
    }

    public double skewness() {
        return QuantLibJNI.Statistics_skewness(this.swigCPtr, this);
    }

    public double kurtosis() {
        return QuantLibJNI.Statistics_kurtosis(this.swigCPtr, this);
    }

    public double min() {
        return QuantLibJNI.Statistics_min(this.swigCPtr, this);
    }

    public double max() {
        return QuantLibJNI.Statistics_max(this.swigCPtr, this);
    }

    public void reset() {
        QuantLibJNI.Statistics_reset(this.swigCPtr, this);
    }

    public void add(double value, double weight) {
        QuantLibJNI.Statistics_add__SWIG_0(this.swigCPtr, this, value, weight);
    }

    public void add(double value) {
        QuantLibJNI.Statistics_add__SWIG_1(this.swigCPtr, this, value);
    }

    public void add(DoubleVector values) {
        QuantLibJNI.Statistics_add__SWIG_2(this.swigCPtr, this, DoubleVector.getCPtr(values), values);
    }

    public void add(DoubleVector values, DoubleVector weights) {
        QuantLibJNI.Statistics_add__SWIG_3(this.swigCPtr, this, DoubleVector.getCPtr(values), values, DoubleVector.getCPtr(weights), weights);
    }

    public Statistics() {
        this(QuantLibJNI.new_Statistics(), true);
    }
}

