/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.Exercise;
import com.github.vonrosen.quantlib.GeneralizedBlackScholesProcess;
import com.github.vonrosen.quantlib.Instrument;
import com.github.vonrosen.quantlib.Payoff;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.SampledCurve;

public class VanillaOption
extends Instrument {
    private transient long swigCPtr;

    protected VanillaOption(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.VanillaOption_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VanillaOption obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_VanillaOption(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public VanillaOption(Payoff payoff, Exercise exercise) {
        this(QuantLibJNI.new_VanillaOption(Payoff.getCPtr(payoff), payoff, Exercise.getCPtr(exercise), exercise), true);
    }

    public SampledCurve priceCurve() {
        return new SampledCurve(QuantLibJNI.VanillaOption_priceCurve(this.swigCPtr, this), true);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI.VanillaOption_impliedVolatility__SWIG_0(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations, double minVol) {
        return QuantLibJNI.VanillaOption_impliedVolatility__SWIG_1(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations, minVol);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, long maxEvaluations) {
        return QuantLibJNI.VanillaOption_impliedVolatility__SWIG_2(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy, maxEvaluations);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy) {
        return QuantLibJNI.VanillaOption_impliedVolatility__SWIG_3(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process, accuracy);
    }

    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process) {
        return QuantLibJNI.VanillaOption_impliedVolatility__SWIG_4(this.swigCPtr, this, targetValue, GeneralizedBlackScholesProcess.getCPtr(process), process);
    }

    public double delta() {
        return QuantLibJNI.VanillaOption_delta(this.swigCPtr, this);
    }

    public double gamma() {
        return QuantLibJNI.VanillaOption_gamma(this.swigCPtr, this);
    }

    public double theta() {
        return QuantLibJNI.VanillaOption_theta(this.swigCPtr, this);
    }

    public double thetaPerDay() {
        return QuantLibJNI.VanillaOption_thetaPerDay(this.swigCPtr, this);
    }

    public double vega() {
        return QuantLibJNI.VanillaOption_vega(this.swigCPtr, this);
    }

    public double rho() {
        return QuantLibJNI.VanillaOption_rho(this.swigCPtr, this);
    }

    public double dividendRho() {
        return QuantLibJNI.VanillaOption_dividendRho(this.swigCPtr, this);
    }

    public double strikeSensitivity() {
        return QuantLibJNI.VanillaOption_strikeSensitivity(this.swigCPtr, this);
    }
}

