/*
 * Decompiled with CFR 0.152.
 */
package com.github.vonrosen.quantlib;

import com.github.vonrosen.quantlib.PricingEngine;
import com.github.vonrosen.quantlib.QuantLibJNI;
import com.github.vonrosen.quantlib.QuoteHandle;
import com.github.vonrosen.quantlib.VolatilityType;

public class _CalibrationHelper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected _CalibrationHelper(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(_CalibrationHelper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete__CalibrationHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setPricingEngine(PricingEngine engine) {
        QuantLibJNI._CalibrationHelper_setPricingEngine(this.swigCPtr, this, PricingEngine.getCPtr(engine), engine);
    }

    public double marketValue() {
        return QuantLibJNI._CalibrationHelper_marketValue(this.swigCPtr, this);
    }

    public double modelValue() {
        return QuantLibJNI._CalibrationHelper_modelValue(this.swigCPtr, this);
    }

    public double calibrationError() {
        return QuantLibJNI._CalibrationHelper_calibrationError(this.swigCPtr, this);
    }

    public double impliedVolatility(double targetValue, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI._CalibrationHelper_impliedVolatility(this.swigCPtr, this, targetValue, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double blackPrice(double volatility) {
        return QuantLibJNI._CalibrationHelper_blackPrice(this.swigCPtr, this, volatility);
    }

    public QuoteHandle volatility() {
        return new QuoteHandle(QuantLibJNI._CalibrationHelper_volatility(this.swigCPtr, this), true);
    }

    public VolatilityType volatilityType() {
        return VolatilityType.swigToEnum(QuantLibJNI._CalibrationHelper_volatilityType(this.swigCPtr, this));
    }

    public static final class CalibrationErrorType {
        public static final CalibrationErrorType RelativePriceError = new CalibrationErrorType("RelativePriceError");
        public static final CalibrationErrorType PriceError = new CalibrationErrorType("PriceError");
        public static final CalibrationErrorType ImpliedVolError = new CalibrationErrorType("ImpliedVolError");
        private static CalibrationErrorType[] swigValues = new CalibrationErrorType[]{RelativePriceError, PriceError, ImpliedVolError};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static CalibrationErrorType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && CalibrationErrorType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (CalibrationErrorType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + CalibrationErrorType.class + " with value " + swigValue);
        }

        private CalibrationErrorType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private CalibrationErrorType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private CalibrationErrorType(String swigName, CalibrationErrorType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

