/*
 * Decompiled with CFR 0.152.
 */
package vowpalWabbit.learner;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import vowpalWabbit.learner.VWLearner;
import vowpalWabbit.learner.VWLearners;

abstract class VWBase
implements VWLearner {
    private volatile boolean isOpen = true;
    final Lock lock = new ReentrantLock();
    protected final long nativePointer;
    private static final Lock globalLock = new ReentrantLock();

    VWBase(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    @Override
    public final void close() throws IOException {
        try {
            this.closer().call();
        }
        catch (Exception e) {
            throw new IOException("An exception occurred while attempting to close VW Model with native pointer " + this.nativePointer, e);
        }
    }

    @Override
    public final Callable<Boolean> closer() {
        return new Closer();
    }

    final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void saveModel(File filename) {
        block4: {
            this.lock.lock();
            try {
                if (this.isOpen()) {
                    VWLearners.saveModel(this.nativePointer, filename.getPath());
                    break block4;
                }
                throw new IllegalStateException("Already closed.");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VWBase vwBase = (VWBase)o;
        return this.nativePointer == vwBase.nativePointer;
    }

    public int hashCode() {
        return (int)(this.nativePointer ^ this.nativePointer >>> 32);
    }

    private class Closer
    implements Callable<Boolean> {
        private Closer() {
        }

        @Override
        public Boolean call() {
            VWBase.this.lock.lock();
            try {
                boolean attemptingToClose = VWBase.this.isOpen;
                if (VWBase.this.isOpen) {
                    VWBase.this.isOpen = false;
                    globalLock.lock();
                    try {
                        VWLearners.performRemainingPasses(VWBase.this.nativePointer);
                    }
                    finally {
                        globalLock.unlock();
                    }
                    VWLearners.closeInstance(VWBase.this.nativePointer);
                }
                Boolean bl = attemptingToClose;
                return bl;
            }
            finally {
                VWBase.this.lock.unlock();
            }
        }
    }
}

