/*
 * Decompiled with CFR 0.152.
 */
package vowpalWabbit.learner;

import vowpalWabbit.learner.VWBase;
import vowpalWabbit.learner.VWLearner;

abstract class VWIntLearner
extends VWBase
implements VWLearner {
    VWIntLearner(long nativePointer) {
        super(nativePointer);
    }

    private int learnOrPredict(String example, boolean learn) {
        this.lock.lock();
        try {
            if (this.isOpen()) {
                int n = this.predict(example, learn, this.nativePointer);
                return n;
            }
            throw new IllegalStateException("Already closed.");
        }
        finally {
            this.lock.unlock();
        }
    }

    private int learnOrPredict(String[] example, boolean learn) {
        this.lock.lock();
        try {
            if (this.isOpen()) {
                int n = this.predictMultiline(example, learn, this.nativePointer);
                return n;
            }
            throw new IllegalStateException("Already closed.");
        }
        finally {
            this.lock.unlock();
        }
    }

    public int predict(String example) {
        return this.learnOrPredict(example, false);
    }

    public int learn(String example) {
        return this.learnOrPredict(example, true);
    }

    public int predict(String[] example) {
        return this.learnOrPredict(example, false);
    }

    public int learn(String[] example) {
        return this.learnOrPredict(example, true);
    }

    protected abstract int predict(String var1, boolean var2, long var3);

    protected abstract int predictMultiline(String[] var1, boolean var2, long var3);
}

