package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractFloatCollection implements FloatCollection
{
    protected FloatLookupContainer testContainer;
    protected FloatPredicate testPredicate;

    protected FloatPredicate containsTestPredicate = new FloatPredicate() {

        @Override
        public final boolean apply(final float k)
        {
            return AbstractFloatCollection.this.testContainer.contains(k);
        }
    };

    protected FloatPredicate containsNegateTestPredicate = new FloatPredicate() {

        @Override
        public final boolean apply(final float k)
        {
            return !AbstractFloatCollection.this.testContainer.contains(k);
        }
    };

    protected FloatPredicate negatePredicate = new FloatPredicate() {

        @Override
        public final boolean apply(final float k)
        {
            return !AbstractFloatCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final FloatLookupContainer c)
    {
        // We know c holds sub-types of float and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final FloatLookupContainer c)
    {
        // We know c holds sub-types of float and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final FloatPredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public float[] toArray(final float[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final FloatCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public float [] toArray()
     
    {
        try {

            return toArray((new float[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
