package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.predicates.IntPredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractIntCollection implements IntCollection
{
    protected IntLookupContainer testContainer;
    protected IntPredicate testPredicate;

    protected IntPredicate containsTestPredicate = new IntPredicate() {

        @Override
        public final boolean apply(final int k)
        {
            return AbstractIntCollection.this.testContainer.contains(k);
        }
    };

    protected IntPredicate containsNegateTestPredicate = new IntPredicate() {

        @Override
        public final boolean apply(final int k)
        {
            return !AbstractIntCollection.this.testContainer.contains(k);
        }
    };

    protected IntPredicate negatePredicate = new IntPredicate() {

        @Override
        public final boolean apply(final int k)
        {
            return !AbstractIntCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final IntLookupContainer c)
    {
        // We know c holds sub-types of int and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final IntLookupContainer c)
    {
        // We know c holds sub-types of int and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final IntPredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public int[] toArray(final int[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final IntCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public int [] toArray()
     
    {
        try {

            return toArray((new int[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
