package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractShortCollection implements ShortCollection
{
    protected ShortLookupContainer testContainer;
    protected ShortPredicate testPredicate;

    protected ShortPredicate containsTestPredicate = new ShortPredicate() {

        @Override
        public final boolean apply(final short k)
        {
            return AbstractShortCollection.this.testContainer.contains(k);
        }
    };

    protected ShortPredicate containsNegateTestPredicate = new ShortPredicate() {

        @Override
        public final boolean apply(final short k)
        {
            return !AbstractShortCollection.this.testContainer.contains(k);
        }
    };

    protected ShortPredicate negatePredicate = new ShortPredicate() {

        @Override
        public final boolean apply(final short k)
        {
            return !AbstractShortCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final ShortLookupContainer c)
    {
        // We know c holds sub-types of short and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final ShortLookupContainer c)
    {
        // We know c holds sub-types of short and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final ShortPredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public short[] toArray(final short[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final ShortCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public short [] toArray()
     
    {
        try {

            return toArray((new short[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
