package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.cursors.CharObjectCursor;

/**
 * An associative container with unique binding from keys to a single value.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:24+0200",
    value = "KTypeVTypeMap.java") 
public interface CharObjectMap<VType>
extends CharObjectAssociativeContainer<VType>
{
    /**
     * Place a given key and value in the container.
     * @return Returns the value previously stored under the given key, if an equal key is already in the map <b>and replaces the existing
     *  value only </b> with the argument value. If the given key was not already in the map,
     *  the given (key, value) pair is inserted in the map and the default value is returned.
     */
    VType put(char key, VType value);

    /**
     * <a href="http://trove4j.sourceforge.net">Trove</a>-inspired API method. An equivalent
     * of the following code:
     * <pre>
     * if (!map.containsKey(key))
     *      map.put(key, value);
     * </pre>
     * 
     * @param key The key of the value to check.
     * @param value The value to put if <code>key</code> does not exist.
     * @return <code>true</code> if <code>key</code> did not exist and <code>value</code>
     * was placed in the map.
     */
    boolean putIfAbsent(final char key, final VType value);

      

      

    /**
     * @return Returns the value associated with the given key, or the default value
     * if the key is not associated with any value.
     *
     */
    VType get(char key);

    /**
     * Puts all keys from another container to this map, replacing the values
     * of existing keys, if such keys are present.
     * 
     * @return Returns the number of keys added to the map as a result of this
     * call (not previously present in the map). Values of existing keys are overwritten.
     */
    int putAll(CharObjectAssociativeContainer<? extends VType> container);

    /**
     * Puts all keys from an iterable cursor to this map, replacing the values
     * of existing keys, if such keys are present.
     * 
     * @return Returns the number of keys added to the map as a result of this
     * call (not previously present in the map). Values of existing keys are overwritten.
     */
    int putAll(Iterable<? extends CharObjectCursor<? extends VType>> iterable);

    /**
     * Remove the (key, value) pair associated with the given key, and returns the assocaited value.
     * The default value is returned if the key did not exist in the map.
     * @param key
     */
    VType remove(char key);

    /**
     * Clear all keys and values in the container.
     */
    void clear();

    /**
     * Returns the "default value" value used in containers methods returning
     * "default value"
     */
    VType getDefaultValue();

    /**
     * Set the "default value" value to be used in containers methods returning
     * "default value"
     */
    void setDefaultValue(final VType defaultValue);
}
