package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.predicates.DoublePredicate;

/**
 * A collection allows basic, efficient operations on sets of elements
 * (difference and intersection).
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeCollection.java") 
public interface DoubleCollection extends DoubleContainer
{
    /**
     * Removes all occurrences of <code>e</code> from this collection.
     * 
     * @param e Element to be removed from this collection, if present.
     * @return The number of removed elements as a result of this call.
     */
    int removeAll(double e);

    /**
     * Removes all elements in this collection that are present
     * in <code>c</code>. Runs in time proportional to the number
     * of elements in this collection. Equivalent of sets difference.
     * 
     * @return Returns the number of removed elements.
     */
    int removeAll(DoubleLookupContainer c);

    /**
     * Removes all elements in this collection for which the
     * given predicate returns <code>true</code>.
     * 
     * @return Returns the number of removed elements.
     */
    int removeAll(DoublePredicate predicate);

    /**
     * Keeps all elements in this collection that are present
     * in <code>c</code>. Runs in time proportional to the number
     * of elements in this collection. Equivalent of sets intersection.
     * 
     * @return Returns the number of removed elements.
     */
    int retainAll(DoubleLookupContainer c);

    /**
     * Keeps all elements in this collection for which the
     * given predicate returns <code>true</code>.
     * 
     * @return Returns the number of removed elements.
     */
    int retainAll(DoublePredicate predicate);

    /**
     * Removes all elements from this collection.
     */
    void clear();
}
