package com.carrotsearch.hppcrt;

import java.util.Arrays;

  
/**
 * Utility class gathering array or FloatIndexedContainer handling algorithms for <code>float</code>s.
 * This is a kind of complement for {@link java.util.Arrays}.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeArrays.java") 
public final class FloatArrays
{
    /**
     * public  static instance of an empty array of <code>float</code>s.
     */
         public final static float[] EMPTY =  (new float[(0)]);
      

    final private static int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;

    /**
     * Batch blanking array size
     */
    final private static int BLANK_ARRAY_SIZE = 1 << FloatArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;

    /**
     * Batch blanking array with float nulls
     */
         final private static float[] BLANKING_OBJECT_ARRAY = (new float[(FloatArrays.BLANK_ARRAY_SIZE)]);
      

    private FloatArrays() {

        //nothing
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of table, into
     * [[slice_2][slice_1]]in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final float[] table, final int from, final int mid, final int to) {

        FloatArrays.reverse(table, from, mid);
        FloatArrays.reverse(table, mid, to);
        FloatArrays.reverse(table, from, to);
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of FloatIndexedContainer, into
     * [[slice_2][slice_1]] in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final FloatIndexedContainer table, final int from, final int mid, final int to) {

        FloatArrays.reverse(table, from, mid);
        FloatArrays.reverse(table, mid, to);
        FloatArrays.reverse(table, from, to);
    }

    /**
     * Reverse the elements positions of the specified range of array table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final float[] table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        float tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    /**
     * Reverse the elements positions of the specified range of FloatIndexedContainer table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final FloatIndexedContainer table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        float tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    /**
     * Method to blank any float[] array elements to its default value
     * from [startIndex; endIndex[, equivalent to {@link Arrays}.fill(objectArray, startIndex, endIndex, 0 or null)
     */
    public static  void blankArray(final float[] objectArray, final int startIndex, final int endIndex) {

        assert startIndex <= endIndex;

        final int size = endIndex - startIndex;
        final int nbChunks = size >> FloatArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;
        //compute remainder
        final int rem = size & (FloatArrays.BLANK_ARRAY_SIZE - 1);

        for (int i = 0; i < nbChunks; i++) {

            System.arraycopy(FloatArrays.BLANKING_OBJECT_ARRAY, 0,
                    objectArray, startIndex + (i << FloatArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    FloatArrays.BLANK_ARRAY_SIZE);
        } //end for

        //fill the reminder
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << FloatArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    startIndex + (nbChunks << FloatArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT) + rem, (0f));
        }
    }

}
