package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.IntCollection;
import com.carrotsearch.hppcrt.cursors.IntCursor;

/**
 * A set of <code>int</code>s.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeSet.java") 
public interface IntSet extends IntCollection
{
    /**
     * Adds <code>k</code> to the set.
     * 
     * @return Returns <code>true</code> if this element was not part of the set before. Returns
     * <code>false</code> if an equal element is already part of the set, <b>and leaves the set unchanged. </b>.
     */
    boolean add(int k);

    /**
     * Adds all elements from a given container to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final IntContainer container);

    /**
     * Adds all elements from a given iterable to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final Iterable<? extends IntCursor> iterable);

    /**
     * Remove all elements of the set matching key. Returns true
     * if key was present in the set and has been successfully removed.
     * This is indeed an alias for {@code IntCollection.removeAll(key) > 0}
     * @see IntCollection#removeAll
     */
    boolean remove(int key);
}
