package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.LongCollection;
import com.carrotsearch.hppcrt.cursors.LongCursor;

/**
 * A set of <code>long</code>s.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeSet.java") 
public interface LongSet extends LongCollection
{
    /**
     * Adds <code>k</code> to the set.
     * 
     * @return Returns <code>true</code> if this element was not part of the set before. Returns
     * <code>false</code> if an equal element is already part of the set, <b>and leaves the set unchanged. </b>.
     */
    boolean add(long k);

    /**
     * Adds all elements from a given container to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final LongContainer container);

    /**
     * Adds all elements from a given iterable to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final Iterable<? extends LongCursor> iterable);

    /**
     * Remove all elements of the set matching key. Returns true
     * if key was present in the set and has been successfully removed.
     * This is indeed an alias for {@code LongCollection.removeAll(key) > 0}
     * @see LongCollection#removeAll
     */
    boolean remove(long key);
}
