package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.*;
import com.carrotsearch.hppcrt.cursors.*;
import com.carrotsearch.hppcrt.predicates.*;
import com.carrotsearch.hppcrt.procedures.*;
import com.carrotsearch.hppcrt.hash.*;

  
  
  
// If RH is defined, RobinHood Hashing is in effect
  

/**
 * A hash set of <code>byte</code>s, implemented using using open
 * addressing with linear probing for collision resolution.
 *
 *
 * <p>
 * The internal buffers of this implementation ({@link #keys}, etc...)
 * are always allocated to the nearest size that is a power of two. When
 * the capacity exceeds the given load factor, the buffer size is doubled.
 * </p>
 * 
 *
 *
 *
 *
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:33+0200",
    value = "KTypeHashSet.java") 
public class ByteHashSet
extends AbstractByteCollection
implements ByteLookupContainer, ByteSet, Cloneable
{
    /**
     * Hash-indexed array holding all set entries.
     * <p>
     * Direct set iteration: iterate  {keys[i]} for i in [0; keys.length[ where keys[i] != 0/null, then also
     * {0/null} is in the set if {@link #allocatedDefaultKey} = true.
     * </p>
     */
    public           byte []
           
            keys;

      
      

    /**
     * True if key = 0/null is in the map.
     */
    public boolean allocatedDefaultKey = false;

    /**
     * Cached number of assigned slots in {@link #keys}.
     */
    protected int assigned;

    /**
     * The load factor for this map (fraction of allocated slots
     * before the buffers must be rehashed or reallocated).
     */
    protected final double loadFactor;

    /**
     * Resize buffers when {@link #keys} hits this value.
     */
    private int resizeAt;

    /**
     * Per-instance perturbation
     * introduced in rehashing to create a unique key distribution.
     */
    private final int perturbation = Containers.randomSeed32();

      

    /**
     * Default constructor: Creates a hash set with the default capacity of {@link Containers#DEFAULT_EXPECTED_ELEMENTS},
     * load factor of {@link HashContainers#DEFAULT_LOAD_FACTOR}.
     */
    public ByteHashSet() {
        this(Containers.DEFAULT_EXPECTED_ELEMENTS, HashContainers.DEFAULT_LOAD_FACTOR);
    }

    /**
     * Creates a hash set with the given capacity,
     * load factor of {@link HashContainers#DEFAULT_LOAD_FACTOR}.
     */
    public ByteHashSet(final int initialCapacity) {
        this(initialCapacity, HashContainers.DEFAULT_LOAD_FACTOR);
    }

    /**
     * Creates a hash set with the given capacity and load factor.
     */
    public ByteHashSet(final int initialCapacity, final double loadFactor) {
        this.loadFactor = loadFactor;
        //take into account of the load factor to guarantee no reallocations before reaching  initialCapacity.
        allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    /**
     * Creates a hash set from elements of another container. Default load factor is used.
     */
    public ByteHashSet(final ByteContainer container) {
        this(container.size());
        addAll(container);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean add(byte key) {

        if (((key) == (byte)0)) {

            if (this.allocatedDefaultKey) {

                return false;
            }

            this.allocatedDefaultKey = true;

            return true;
        }

        final int mask = this.keys.length - 1;

        final byte[] keys = ((this.keys));

        int slot = (BitMixer.mix((key) , this.perturbation)) & mask;
        byte existing;

          

        while (!((existing = keys[slot]) == (byte)0)) {

              

              
            if (   ((((key)) == ((existing))))) {
                return false;
            }

              

            slot = (slot + 1) & mask;
              
        }

        // Check if we need to grow. If so, reallocate new data,
        // fill in the last element and rehash.
        if (this.assigned == this.resizeAt) {

            expandAndAdd(key, slot);
        } else {
            this.assigned++;
              

            keys[slot] = key;

              
        }
        return true;
    }

    /**
     * Adds two elements to the set.
     */
    public int add(final byte e1, final byte e2) {
        int count = 0;
        if (add(e1)) {
            count++;
        }
        if (add(e2)) {
            count++;
        }
        return count;
    }

    /**
     * Vararg-signature method for adding elements to this set.
     * <p><b>This method is handy, but costly if used in tight loops (anonymous
     * array passing)</b></p>
     *
     * @return Returns the number of elements that were added to the set
     * (were not present in the set).
     */
    public int add(final byte... elements) {
        int count = 0;
        for (final byte e : elements) {
            if (add(e)) {
                count++;
            }
        }
        return count;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int addAll(final ByteContainer container) {
        return addAll((Iterable<? extends ByteCursor>) container);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int addAll(final Iterable<? extends ByteCursor> iterable) {
        int count = 0;
        for (final ByteCursor cursor : iterable) {
            if (add(cursor.value)) {
                count++;
            }
        }
        return count;
    }

    /**
     * Expand the internal storage buffers (capacity) or rehash current
     * keys and values if there are a lot of deleted slots.
     */
    private void expandAndAdd(final byte pendingKey, final int freeSlot) {
        assert this.assigned == this.resizeAt;

        //default sentinel value is never in the keys[] array, so never trigger reallocs
        assert (!((pendingKey) == (byte)0));

        // Try to allocate new buffers first. If we OOM, it'll be now without
        // leaving the data structure in an inconsistent state.
        final byte[] oldKeys = ((this.keys));

        allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));

        // We have succeeded at allocating new data so insert the pending key/value at
        // the free slot in the old arrays before rehashing.

        this.assigned++;

        oldKeys[freeSlot] = pendingKey;

        //Variables for adding
        final int mask = this.keys.length - 1;

        byte key = ((byte)0);
        //adding phase
        int slot = -1;

        final byte[] keys = ((this.keys));

          

          

        //iterate all the old arrays to add in the newly allocated buffers
        //It is important to iterate backwards to minimize the conflict chain length !
        final int perturb = this.perturbation;

        for (int i = oldKeys.length; --i >= 0;) {

            //only consider non-empty slots, of course
            if (!((key = oldKeys[i]) == (byte)0)) {

                slot = (BitMixer.mix((key) , (perturb))) & mask;

                  

                //similar to add(), except all inserted keys are known to be unique.
                while ((!(((keys)[(slot)]) == (byte)0))) {
                      

                    slot = (slot + 1) & mask;

                      
                } //end while

                //place it at that position
                  

                keys[slot] = key;

                  
            }
        }
    }

    /**
     * Allocate internal buffers for a given capacity.
     *
     * @param capacity New capacity (must be a power of two).
     */
    @SuppressWarnings("boxing")
    private void allocateBuffers(final int capacity) {
        try {

            final byte[] keys = (new byte[(capacity)]);

              

            this.keys = keys;

              

            //allocate so that there is at least one slot that remains allocated = false
            //this is compulsory to guarantee proper stop in searching loops
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate buffers to grow from %d -> %d elements",
                    e,
                    (this.keys == null) ? 0 : this.keys.length,
                            capacity);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int removeAll(final byte key) {
        return remove(key) ? 1 : 0;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean remove(final byte key) {

        if (((key) == (byte)0)) {

            if (this.allocatedDefaultKey) {

                this.allocatedDefaultKey = false;
                return true;
            }

            return false;
        }

        final int mask = this.keys.length - 1;

        final byte[] keys = ((this.keys));

        int slot = (BitMixer.mix((key) , this.perturbation)) & mask;
        byte existing;

          

        while (!((existing = keys[slot]) == (byte)0)
                  ) {
            if (((((key)) == ((existing))))) {

                shiftConflictingKeys(slot);
                return true;
            }
            slot = (slot + 1) & mask;

              
        } //end while true

        return false;
    }

    /**
     * Shift all the slot-conflicting keys allocated to (and including) <code>slot</code>.
     */
    private void shiftConflictingKeys(int gapSlot) {

        final int mask = this.keys.length - 1;

        final byte[] keys = ((this.keys));

                  final int perturb = this.perturbation;
          

        // Perform shifts of conflicting keys to fill in the gap.
        int distance = 0;

        while (true) {

            final int slot = (gapSlot + (++distance)) & mask;

            final byte existing = keys[slot];

            if (((existing) == (byte)0)) {
                break;
            }

                         final int idealSlotModMask = (BitMixer.mix((existing) , (perturb))) & mask;
             

            //original HPPC code: shift = (slot - idealSlot) & mask;
            //equivalent to shift = (slot & mask - idealSlot & mask) & mask;
            //since slot and idealSlotModMask are already folded, we have :
            final int shift = (slot - idealSlotModMask) & mask;

            if (shift >= distance) {
                // Entry at this position was originally at or before the gap slot.
                // Move the conflict-shifted entry to the gap's position and repeat the procedure
                // for any entries to the right of the current position, treating it
                // as the new gap.
                keys[gapSlot] = existing;

                  

                gapSlot = slot;
                distance = 0;
            }
        } //end while

        // Mark the last found gap slot without a conflict as empty.
        keys[gapSlot] = ((byte)0);

        this.assigned--;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean contains(final byte key) {

        if (((key) == (byte)0)) {

            return this.allocatedDefaultKey;
        }

        final int mask = this.keys.length - 1;

        final byte[] keys = ((this.keys));

        int slot = (BitMixer.mix((key) , this.perturbation)) & mask;
        byte existing;

          

        while (!((existing = keys[slot]) == (byte)0)
                  ) {
            if (((((key)) == ((existing))))) {
                return true;
            }
            slot = (slot + 1) & mask;

              
        } //end while true

        return false;
    }

    /**
     * {@inheritDoc}
     *
     * <p>Does not release internal buffers.</p>
     */
    @Override
    public void clear() {
        this.assigned = 0;

        // States are always cleared.
        this.allocatedDefaultKey = false;

        //Faster than Arrays.fill(keys, null); // Help the GC.
        ByteArrays.blankArray(this.keys, 0, this.keys.length);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int capacity() {

        return this.resizeAt;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        int h = 0;

        //allocated default key has hash = 0

        final byte[] keys = ((this.keys));

        for (int i = keys.length; --i >= 0;) {
            byte existing;
            if (!((existing = keys[i]) == (byte)0)) {
                h += BitMixer.mix(existing);
            }
        }

        return h;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(final Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }

            //must be of the same class, subclasses are not comparable
            if (obj.getClass() != this.getClass()) {

                return false;
            }

            @SuppressWarnings("unchecked")
            final ByteSet other = (ByteSet) obj;

            //must be of the same size
            if (other.size() != this.size()) {
                return false;
            }

            final EntryIterator it = this.iterator();

            while (it.hasNext()) {
                if (!other.contains(it.next().value)) {
                    //recycle
                    it.release();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * An iterator implementation for {@link #iterator}.
     * Holds a ByteCursor returning (value, index) = (byte value, index the position in {@link ByteHashSet#keys}, or keys.length for key = 0/null.)
     */
    public final class EntryIterator extends AbstractIterator<ByteCursor>
    {
        public final ByteCursor cursor;

        public EntryIterator() {
            this.cursor = new ByteCursor();
            this.cursor.index = -2;
        }

        /**
         * Iterate backwards w.r.t the buffer, to
         * minimize collision chains when filling another hash container (ex. with putAll())
         */
        @Override
        protected ByteCursor fetch() {
            if (this.cursor.index == ByteHashSet.this.keys.length + 1) {

                if (ByteHashSet.this.allocatedDefaultKey) {

                    this.cursor.index = ByteHashSet.this.keys.length;
                    this.cursor.value = ((byte)0);

                    return this.cursor;

                }
                //no value associated with the default key, continue iteration...
                this.cursor.index = ByteHashSet.this.keys.length;

            }

            int i = this.cursor.index - 1;

            while (i >= 0 && !(!(((((ByteHashSet.this.keys)))[(i)]) == (byte)0))) {
                i--;
            }

            if (i == -1) {
                return done();
            }

            this.cursor.index = i;
            this.cursor.value = ((ByteHashSet.this.keys[i]));
            return this.cursor;
        }
    }

    /**
     * internal pool of EntryIterator
     */
    protected final IteratorPool<ByteCursor, EntryIterator> entryIteratorPool = new IteratorPool<ByteCursor, EntryIterator>(
            new ObjectFactory<EntryIterator>() {

                @Override
                public EntryIterator create() {

                    return new EntryIterator();
                }

                @Override
                public void initialize(final EntryIterator obj) {
                    obj.cursor.index = ByteHashSet.this.keys.length + 1;
                }

                @Override
                public void reset(final EntryIterator obj) {
                      

                }
            });

    /**
     * {@inheritDoc}
     *
     */
    @Override
    public EntryIterator iterator() {
        //return new EntryIterator();
        return this.entryIteratorPool.borrow();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <T extends ByteProcedure> T forEach(final T procedure) {
        if (this.allocatedDefaultKey) {

            procedure.apply(((byte)0));
        }

        final byte[] keys = ((this.keys));

        //Iterate in reverse for side-stepping the longest conflict chain
        //in another hash, in case apply() is actually used to fill another hash container.
        for (int i = keys.length - 1; i >= 0; i--) {
            byte existing;
            if (!((existing = keys[i]) == (byte)0)) {
                procedure.apply(existing);
            }
        }

        return procedure;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] toArray(final byte[] target) {
        int count = 0;

        if (this.allocatedDefaultKey) {

            target[count++] = ((byte)0);
        }

        final byte[] keys = ((this.keys));

        for (int i = 0; i < keys.length; i++) {
            byte existing;
            if (!((existing = keys[i]) == (byte)0)) {
                target[count++] = existing;
            }
        }

        assert count == this.size();

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ByteHashSet clone() {
        //clone to size() to prevent eventual exponential growth
        final ByteHashSet cloned = new ByteHashSet(this.size(), this.loadFactor);

        //We must NOT clone, because of the independent perturbation seeds
        cloned.addAll(this);

        return cloned;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <T extends BytePredicate> T forEach(final T predicate) {
        if (this.allocatedDefaultKey) {

            if (!predicate.apply(((byte)0))) {

                return predicate;
            }
        }

        final byte[] keys = ((this.keys));

        //Iterate in reverse for side-stepping the longest conflict chain
        //in another hash, in case apply() is actually used to fill another hash container.
        for (int i = keys.length - 1; i >= 0; i--) {
            byte existing;
            if (!((existing = keys[i]) == (byte)0)) {
                if (!predicate.apply(existing)) {
                    break;
                }
            }
        }

        return predicate;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int removeAll(final BytePredicate predicate) {
        final int before = this.size();

        if (this.allocatedDefaultKey) {

            if (predicate.apply(((byte)0))) {
                this.allocatedDefaultKey = false;
            }
        }

        final byte[] keys = ((this.keys));

        for (int i = 0; i < keys.length;) {
            byte existing;
            if (!((existing = keys[i]) == (byte)0) && predicate.apply(existing)) {

                shiftConflictingKeys(i);
                // Shift, do not increment slot.
            } else {
                i++;
            }
        }

        return before - this.size();
    }

    /**
     * Create a set from a variable number of arguments or an array of <code>byte</code>.
     */
    public static  ByteHashSet from(final byte... elements) {
        final ByteHashSet set = new ByteHashSet(elements.length);
        set.add(elements);
        return set;
    }

    /**
     * Create a set from elements of another container.
     */
    public static  ByteHashSet from(final ByteContainer container) {
        return new ByteHashSet(container);
    }

    /**
     * Create a new hash set with default parameters (shortcut
     * instead of using a constructor).
     */
    public static  ByteHashSet newInstance() {
        return new ByteHashSet();
    }

    /**
     * Returns a new object of this class with no need to declare generic type (shortcut
     * instead of using a constructor).
     */
    public static  ByteHashSet newInstance(final int initialCapacity, final double loadFactor) {
        return new ByteHashSet(initialCapacity, loadFactor);
    }

    //Test for existence in template
      

      

      

      

      
}
