/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongArrays;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongLookupContainer;
import com.carrotsearch.hppcrt.LongSet;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashSet
extends AbstractLongCollection
implements LongLookupContainer,
LongSet,
Cloneable {
    public long[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<LongCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = LongHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public LongHashSet() {
        this(8, 0.75);
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public LongHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public LongHashSet(LongContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(long e1, long e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(long ... elements) {
        int count = 0;
        for (long e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(LongContainer container) {
        return this.addAll((Iterable<? extends LongCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends LongCursor> iterable) {
        int count = 0;
        for (LongCursor longCursor : iterable) {
            if (!this.add(longCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(long pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0L);
        long[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        long key = 0L;
        int slot = -1;
        long[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0L) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            long[] keys = new long[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(long key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        --this.assigned;
    }

    @Override
    public boolean contains(long key) {
        long existing;
        if (key == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        LongArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h = 0;
        long[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            long existing = keys[i];
            if (existing == 0L) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LongSet other = (LongSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((LongCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0L);
        }
        long[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            long existing = keys[i];
            if (existing == 0L) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public long[] toArray(long[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0L;
        }
        long[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            long existing = keys[i];
            if (existing == 0L) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public LongHashSet clone() {
        LongHashSet cloned = new LongHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        long existing;
        if (this.allocatedDefaultKey && !predicate.apply(0L)) {
            return predicate;
        }
        long[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L)) {
            this.allocatedDefaultKey = false;
        }
        long[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            long existing = keys[i];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static LongHashSet from(long ... elements) {
        LongHashSet set = new LongHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static LongHashSet from(LongContainer container) {
        return new LongHashSet(container);
    }

    public static LongHashSet newInstance() {
        return new LongHashSet();
    }

    public static LongHashSet newInstance(int initialCapacity, double loadFactor) {
        return new LongHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == LongHashSet.this.keys.length + 1) {
                if (LongHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = LongHashSet.this.keys.length;
                    this.cursor.value = 0L;
                    return this.cursor;
                }
                this.cursor.index = LongHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongHashSet.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

