/*
 * Decompiled with CFR 0.152.
 */
package com.github.vzakharchenko.mikrotik.services;

import com.github.vzakharchenko.radius.providers.IRadiusServiceProvider;
import com.github.vzakharchenko.radius.providers.IRadiusServiceProviderFactory;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.packet.AccessRequest;

public class LoginServiceProviderFactory
implements IRadiusServiceProviderFactory,
IRadiusServiceProvider {
    public static final String MIKROTIK_LOGIN_SERVICE = "mikrotik-login-service";

    public IRadiusServiceProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return MIKROTIK_LOGIN_SERVICE;
    }

    public String attributeName() {
        return "mikrotik";
    }

    public String serviceName() {
        return "login";
    }

    public boolean checkService(AccessRequest accessRequest) {
        RadiusAttribute serviceTypeAttribute = accessRequest.getAttribute("Service-Type");
        return serviceTypeAttribute != null && "Login-User".equalsIgnoreCase(serviceTypeAttribute.getValueString()) && "mschapv2".equalsIgnoreCase(accessRequest.getAuthProtocol());
    }
}

