/*
 * Decompiled with CFR 0.152.
 */
package com.github.vzakharchenko.mikrotik.services;

import com.github.vzakharchenko.radius.providers.IRadiusServiceProvider;
import com.github.vzakharchenko.radius.providers.IRadiusServiceProviderFactory;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.packet.AccessRequest;

public class PPPServiceProviderFactory
implements IRadiusServiceProviderFactory,
IRadiusServiceProvider {
    public static final String MIKROTIK_PPP_SERVICE = "mikrotik-ppp-service";

    public IRadiusServiceProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return MIKROTIK_PPP_SERVICE;
    }

    public String attributeName() {
        return "mikrotik";
    }

    public String serviceName() {
        return "ppp";
    }

    public boolean checkService(AccessRequest accessRequest) {
        RadiusAttribute serviceTypeAttribute = accessRequest.getAttribute("Framed-Protocol");
        return serviceTypeAttribute != null && "PPP".equalsIgnoreCase(serviceTypeAttribute.getValueString());
    }
}

