/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Netapi32Util;
import java.util.ArrayList;
import waffle.windows.auth.IWindowsComputer;

public class WindowsComputerImpl
implements IWindowsComputer {
    private final String computerName;
    private final String domainName;

    public WindowsComputerImpl(String newComputerName) {
        this.computerName = newComputerName;
        this.domainName = Netapi32Util.getDomainName((String)newComputerName);
    }

    @Override
    public String getComputerName() {
        return this.computerName;
    }

    @Override
    public String[] getGroups() {
        Netapi32Util.LocalGroup[] groups;
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Netapi32Util.LocalGroup group : groups = Netapi32Util.getLocalGroups((String)this.computerName)) {
            groupNames.add(group.name);
        }
        return groupNames.toArray(new String[0]);
    }

    @Override
    public String getJoinStatus() {
        int joinStatus = Netapi32Util.getJoinStatus((String)this.computerName);
        switch (joinStatus) {
            case 3: {
                return "NetSetupDomainName";
            }
            case 1: {
                return "NetSetupUnjoined";
            }
            case 2: {
                return "NetSetupWorkgroupName";
            }
            case 0: {
                return "NetSetupUnknownStatus";
            }
        }
        throw new RuntimeException("Unsupported join status: " + joinStatus);
    }

    @Override
    public String getMemberOf() {
        return this.domainName;
    }
}

