/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import com.google.common.io.BaseEncoding;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.slf4j.LoggerFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateAuthenticator
extends WaffleAuthenticatorBase {
    public NegotiateAuthenticator() {
        this.log = LoggerFactory.getLogger(NegotiateAuthenticator.class);
        this.info = "waffle.apache.NegotiateAuthenticator/1.0";
        this.log.debug("[waffle.apache.NegotiateAuthenticator] loaded");
    }

    public synchronized void startInternal() throws LifecycleException {
        this.log.info("[waffle.apache.NegotiateAuthenticator] started");
        super.startInternal();
    }

    public synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.log.info("[waffle.apache.NegotiateAuthenticator] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(Request request, HttpServletResponse response) {
        Object principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this.log.debug("{} {}, contentlength: {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getContentLength()});
        this.log.debug("authorization: {}, ntlm post: {}", (Object)authorizationHeader, (Object)ntlmPost);
        if (principal != null && !ntlmPost) {
            this.log.debug("previously authenticated user: {}", (Object)principal.getName());
            return true;
        }
        if (!authorizationHeader.isNull()) {
            IWindowsSecurityContext securityContext;
            String securityPackage = authorizationHeader.getSecurityPackage();
            String connectionId = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
            this.log.debug("security package: {}, connection id: {}", (Object)securityPackage, (Object)connectionId);
            if (ntlmPost) {
                this.auth.resetSecurityToken(connectionId);
            }
            byte[] tokenBuffer = authorizationHeader.getTokenBytes();
            this.log.debug("token buffer: {} byte(s)", (Object)tokenBuffer.length);
            try {
                securityContext = this.auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
            }
            catch (Win32Exception e) {
                this.log.warn("error logging in user: {}", (Object)e.getMessage());
                this.log.trace("", (Throwable)e);
                this.sendUnauthorized(response);
                return false;
            }
            this.log.debug("continue required: {}", (Object)securityContext.isContinue());
            byte[] continueTokenBytes = securityContext.getToken();
            if (continueTokenBytes != null && continueTokenBytes.length > 0) {
                String continueToken = BaseEncoding.base64().encode(continueTokenBytes);
                this.log.debug("continue token: {}", (Object)continueToken);
                response.addHeader("WWW-Authenticate", securityPackage + " " + continueToken);
            }
            try {
                if (securityContext.isContinue() || ntlmPost) {
                    response.setHeader("Connection", "keep-alive");
                    response.sendError(401);
                    response.flushBuffer();
                    return false;
                }
            }
            catch (IOException e) {
                this.log.warn("error logging in user: {}", (Object)e.getMessage());
                this.log.trace("", (Throwable)e);
                this.sendUnauthorized(response);
                return false;
            }
            if (this.context == null || this.context.getRealm() == null) {
                this.log.warn("missing context/realm");
                this.sendError(response, 503);
                return false;
            }
            IWindowsIdentity windowsIdentity = securityContext.getIdentity();
            if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
                this.log.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
                this.sendUnauthorized(response);
                return false;
            }
            try {
                this.log.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
                GenericWindowsPrincipal windowsPrincipal = new GenericWindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat);
                this.log.debug("roles: {}", (Object)windowsPrincipal.getRolesString());
                principal = windowsPrincipal;
                HttpSession session = request.getSession(true);
                this.log.debug("session id: {}", (Object)(session == null ? "null" : session.getId()));
                this.register(request, response, (Principal)principal, securityPackage, principal.getName(), null);
                this.log.info("successfully logged in user: {}", (Object)principal.getName());
            }
            finally {
                windowsIdentity.dispose();
                securityContext.dispose();
            }
            return true;
        }
        this.log.debug("authorization required");
        this.sendUnauthorized(response);
        return false;
    }
}

