/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.slf4j.LoggerFactory;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class MixedAuthenticator
extends WaffleAuthenticatorBase {
    public MixedAuthenticator() {
        this.log = LoggerFactory.getLogger(MixedAuthenticator.class);
        this.info = "waffle.apache.MixedAuthenticator/1.0";
        this.log.debug("[waffle.apache.MixedAuthenticator] loaded");
    }

    @Override
    public synchronized void startInternal() throws LifecycleException {
        this.log.info("[waffle.apache.MixedAuthenticator] started");
        super.startInternal();
    }

    public synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.log.info("[waffle.apache.MixedAuthenticator] stopped");
    }

    public boolean authenticate(Request request, HttpServletResponse response) {
        if (this.context == null || this.context.getRealm() == null) {
            this.log.warn("missing context/realm");
            this.sendError(response, 503);
            return false;
        }
        this.log.debug("{} {}, contentlength: {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getContentLength()});
        boolean negotiateCheck = request.getParameter("j_negotiate_check") != null;
        this.log.debug("negotiateCheck: {}", (Object)negotiateCheck);
        boolean securityCheck = request.getParameter("j_security_check") != null;
        this.log.debug("securityCheck: {}", (Object)securityCheck);
        Principal principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this.log.debug("authorization: {}, ntlm post: {}", (Object)authorizationHeader, (Object)ntlmPost);
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (principal != null && !ntlmPost) {
            this.log.debug("previously authenticated user: {}", (Object)principal.getName());
            return true;
        }
        if (negotiateCheck) {
            if (!authorizationHeader.isNull()) {
                return this.negotiate(request, response, authorizationHeader);
            }
            this.log.debug("authorization required");
            this.sendUnauthorized(response);
            return false;
        }
        if (securityCheck) {
            boolean postResult = this.post(request, response);
            if (postResult) {
                this.redirectTo(request, response, request.getServletPath());
            } else {
                this.redirectTo(request, response, loginConfig.getErrorPage());
            }
            return postResult;
        }
        this.redirectTo(request, response, loginConfig.getLoginPage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean negotiate(Request request, HttpServletResponse response, AuthorizationHeader authorizationHeader) {
        IWindowsSecurityContext securityContext;
        String securityPackage = authorizationHeader.getSecurityPackage();
        String connectionId = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
        this.log.debug("security package: {}, connection id: {}", (Object)securityPackage, (Object)connectionId);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        if (ntlmPost) {
            this.auth.resetSecurityToken(connectionId);
        }
        byte[] tokenBuffer = authorizationHeader.getTokenBytes();
        this.log.debug("token buffer: {} byte(s)", (Object)tokenBuffer.length);
        try {
            securityContext = this.auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
        }
        catch (Win32Exception e) {
            this.log.warn("error logging in user: {}", (Object)e.getMessage());
            this.log.trace("", (Throwable)e);
            this.sendUnauthorized(response);
            return false;
        }
        this.log.debug("continue required: {}", (Object)securityContext.isContinue());
        byte[] continueTokenBytes = securityContext.getToken();
        if (continueTokenBytes != null && continueTokenBytes.length > 0) {
            String continueToken = Base64.getEncoder().encodeToString(continueTokenBytes);
            this.log.debug("continue token: {}", (Object)continueToken);
            response.addHeader("WWW-Authenticate", securityPackage + " " + continueToken);
        }
        try {
            if (securityContext.isContinue() || ntlmPost) {
                response.setHeader("Connection", "keep-alive");
                response.sendError(401);
                response.flushBuffer();
                return false;
            }
        }
        catch (IOException e) {
            this.log.warn("error logging in user: {}", (Object)e.getMessage());
            this.log.trace("", (Throwable)e);
            this.sendUnauthorized(response);
            return false;
        }
        IWindowsIdentity windowsIdentity = securityContext.getIdentity();
        if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
            this.log.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
            this.sendUnauthorized(response);
            return false;
        }
        try {
            this.log.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
            GenericPrincipal genericPrincipal = this.createPrincipal(windowsIdentity);
            this.log.debug("roles: {}", (Object)String.join((CharSequence)", ", genericPrincipal.getRoles()));
            HttpSession session = request.getSession(true);
            this.log.debug("session id: {}", (Object)(session == null ? "null" : session.getId()));
            this.register(request, response, (Principal)genericPrincipal, securityPackage, genericPrincipal.getName(), null);
            this.log.info("successfully logged in user: {}", (Object)genericPrincipal.getName());
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean post(Request request, HttpServletResponse response) {
        IWindowsIdentity windowsIdentity;
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        this.log.debug("logging in: {}", (Object)username);
        try {
            windowsIdentity = this.auth.logonUser(username, password);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.trace("", (Throwable)e);
            return false;
        }
        if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
            this.log.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
            return false;
        }
        try {
            this.log.debug("successfully logged in {} ({})", (Object)username, (Object)windowsIdentity.getSidString());
            GenericPrincipal genericPrincipal = this.createPrincipal(windowsIdentity);
            this.log.debug("roles: {}", (Object)String.join((CharSequence)", ", genericPrincipal.getRoles()));
            HttpSession session = request.getSession(true);
            this.log.debug("session id: {}", (Object)(session == null ? "null" : session.getId()));
            this.register(request, response, (Principal)genericPrincipal, "FORM", genericPrincipal.getName(), null);
            this.log.info("successfully logged in user: {}", (Object)genericPrincipal.getName());
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    private void redirectTo(Request request, HttpServletResponse response, String url) {
        try {
            this.log.debug("redirecting to: {}", (Object)url);
            ServletContext servletContext = this.context.getServletContext();
            RequestDispatcher disp = servletContext.getRequestDispatcher(url);
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            this.log.error(e.getMessage());
            this.log.trace("", e);
            throw new RuntimeException(e);
        }
    }
}

