/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.core;

public class OS {
    protected static Boolean m_IsWindows;
    protected static Boolean m_IsMac;
    protected static Boolean m_IsLinux;
    protected static Boolean m_IsAndroid;

    public static synchronized boolean isWindows() {
        if (m_IsWindows == null) {
            String os = System.getProperty("os.name").toLowerCase();
            m_IsWindows = os.contains("windows");
        }
        return m_IsWindows;
    }

    public static synchronized boolean isMac() {
        if (m_IsMac == null) {
            String os = System.getProperty("os.name").toLowerCase();
            m_IsMac = os.startsWith("mac os");
        }
        return m_IsMac;
    }

    public static synchronized boolean isLinux() {
        if (m_IsLinux == null) {
            m_IsLinux = System.getProperty("os.name").toLowerCase().startsWith("linux") && !OS.isAndroid();
        }
        return m_IsLinux;
    }

    public static synchronized boolean isAndroid() {
        if (m_IsAndroid == null) {
            m_IsAndroid = System.getProperty("java.vm.vendor").toLowerCase().contains("android") || System.getProperty("java.vendor").toLowerCase().contains("android") || System.getProperty("java.vendor.url").toLowerCase().contains("android");
        }
        return m_IsAndroid;
    }

    public static synchronized int getBitness() {
        String arch = System.getProperty("os.arch");
        if (arch.endsWith("86")) {
            return 32;
        }
        if (arch.endsWith("64")) {
            return 64;
        }
        throw new IllegalStateException("Cannot interpret 'os.arch' for bitness: " + arch);
    }
}

